/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.jwt;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.security.authc.jwt.JwtUtil;

public class JwtAuthenticationToken
implements AuthenticationToken {
    private SignedJWT signedJWT;
    private final String principal;
    private final byte[] userCredentialsHash;
    @Nullable
    private final SecureString clientAuthenticationSharedSecret;

    public static JwtAuthenticationToken tryParseJwt(SecureString userCredentials, @Nullable SecureString clientCredentials) {
        SignedJWT signedJWT = JwtUtil.parseSignedJWT(userCredentials);
        if (signedJWT == null) {
            return null;
        }
        return new JwtAuthenticationToken(signedJWT, JwtUtil.sha256((CharSequence)userCredentials), clientCredentials);
    }

    public JwtAuthenticationToken(SignedJWT signedJWT, byte[] userCredentialsHash, @Nullable SecureString clientAuthenticationSharedSecret) {
        this.signedJWT = Objects.requireNonNull(signedJWT);
        this.principal = this.buildTokenPrincipal();
        this.userCredentialsHash = Objects.requireNonNull(userCredentialsHash);
        if (clientAuthenticationSharedSecret != null && clientAuthenticationSharedSecret.isEmpty()) {
            throw new IllegalArgumentException("Client shared secret must be non-empty");
        }
        this.clientAuthenticationSharedSecret = clientAuthenticationSharedSecret;
    }

    public String principal() {
        return this.principal;
    }

    public SecureString credentials() {
        return null;
    }

    public SignedJWT getSignedJWT() {
        return this.signedJWT;
    }

    public JWTClaimsSet getJWTClaimsSet() {
        try {
            return this.signedJWT.getJWTClaimsSet();
        }
        catch (ParseException e) {
            assert (false) : "The JWT claims set should have already been successfully parsed before building the JWT authentication token";
            throw new IllegalStateException(e);
        }
    }

    public byte[] getUserCredentialsHash() {
        return this.userCredentialsHash;
    }

    public SecureString getClientAuthenticationSharedSecret() {
        return this.clientAuthenticationSharedSecret;
    }

    public void clearCredentials() {
        this.signedJWT = null;
        Arrays.fill(this.userCredentialsHash, (byte)0);
        if (this.clientAuthenticationSharedSecret != null) {
            this.clientAuthenticationSharedSecret.close();
        }
    }

    public String toString() {
        return JwtAuthenticationToken.class.getSimpleName() + "=" + this.principal;
    }

    private String buildTokenPrincipal() {
        JWTClaimsSet jwtClaimsSet = this.getJWTClaimsSet();
        StringBuilder principalBuilder = new StringBuilder();
        block0: for (String claimName : new TreeSet(jwtClaimsSet.getClaims().keySet())) {
            List claimValuesList;
            Object claimValue = jwtClaimsSet.getClaim(claimName);
            if (claimValue == null) continue;
            if (claimValue instanceof String) {
                if (!principalBuilder.isEmpty()) {
                    principalBuilder.append(' ');
                }
                principalBuilder.append('\'').append(claimName).append(':').append((String)claimValue).append('\'');
                continue;
            }
            if (!(claimValue instanceof List) || (claimValuesList = (List)claimValue).isEmpty()) continue;
            for (Object claimValueElem : claimValuesList) {
                if (claimValueElem instanceof String) continue;
                continue block0;
            }
            if (!principalBuilder.isEmpty()) {
                principalBuilder.append(' ');
            }
            principalBuilder.append('\'').append(claimName).append(':');
            for (int i = 0; i < claimValuesList.size(); ++i) {
                if (i > 0) {
                    principalBuilder.append(',');
                }
                principalBuilder.append((String)claimValuesList.get(i));
            }
            principalBuilder.append('\'');
        }
        if (principalBuilder.isEmpty()) {
            return "<unrecognized JWT token>";
        }
        return principalBuilder.toString();
    }
}

