/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.http.HttpPreRequest;
import org.elasticsearch.node.Node;
import org.elasticsearch.telemetry.metric.MeterRegistry;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationFailureHandler;
import org.elasticsearch.xpack.core.security.authc.AuthenticationServiceField;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.Realm;
import org.elasticsearch.xpack.core.security.authc.support.AuthenticationContextSerializer;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.audit.AuditTrail;
import org.elasticsearch.xpack.security.audit.AuditTrailService;
import org.elasticsearch.xpack.security.audit.AuditUtil;
import org.elasticsearch.xpack.security.authc.ApiKeyAuthenticator;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.authc.Authenticator;
import org.elasticsearch.xpack.security.authc.AuthenticatorChain;
import org.elasticsearch.xpack.security.authc.OAuth2TokenAuthenticator;
import org.elasticsearch.xpack.security.authc.PluggableAuthenticatorChain;
import org.elasticsearch.xpack.security.authc.Realms;
import org.elasticsearch.xpack.security.authc.RealmsAuthenticator;
import org.elasticsearch.xpack.security.authc.ServiceAccountAuthenticator;
import org.elasticsearch.xpack.security.authc.TokenService;
import org.elasticsearch.xpack.security.authc.service.ServiceAccountService;
import org.elasticsearch.xpack.security.operator.OperatorPrivileges;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;

public class AuthenticationService {
    static final Setting<Boolean> SUCCESS_AUTH_CACHE_ENABLED = Setting.boolSetting((String)"xpack.security.authc.success_cache.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<Integer> SUCCESS_AUTH_CACHE_MAX_SIZE = Setting.intSetting((String)"xpack.security.authc.success_cache.size", (int)10000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<TimeValue> SUCCESS_AUTH_CACHE_EXPIRE_AFTER_ACCESS = Setting.timeSetting((String)"xpack.security.authc.success_cache.expire_after_access", (TimeValue)TimeValue.timeValueHours((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Logger logger = LogManager.getLogger(AuthenticationService.class);
    private final Realms realms;
    private final AuditTrailService auditTrailService;
    private final AuthenticationFailureHandler failureHandler;
    private final ThreadContext threadContext;
    private final Cache<String, Realm> lastSuccessfulAuthCache;
    private final AtomicLong numInvalidation = new AtomicLong();
    private final AuthenticatorChain authenticatorChain;

    public AuthenticationService(Settings settings, Realms realms, AuditTrailService auditTrailService, AuthenticationFailureHandler failureHandler, ThreadPool threadPool, AnonymousUser anonymousUser, TokenService tokenService, ApiKeyService apiKeyService, ServiceAccountService serviceAccountService, OperatorPrivileges.OperatorPrivilegesService operatorPrivilegesService, PluggableAuthenticatorChain pluggableAuthenticatorChain, MeterRegistry meterRegistry) {
        this.realms = realms;
        this.auditTrailService = auditTrailService;
        this.failureHandler = failureHandler;
        this.threadContext = threadPool.getThreadContext();
        this.lastSuccessfulAuthCache = (Boolean)SUCCESS_AUTH_CACHE_ENABLED.get(settings) != false ? CacheBuilder.builder().setMaximumWeight(Integer.toUnsignedLong((Integer)SUCCESS_AUTH_CACHE_MAX_SIZE.get(settings))).setExpireAfterAccess((TimeValue)SUCCESS_AUTH_CACHE_EXPIRE_AFTER_ACCESS.get(settings)).build() : null;
        String nodeName = (String)Node.NODE_NAME_SETTING.get(settings);
        this.authenticatorChain = new AuthenticatorChain(settings, operatorPrivilegesService, anonymousUser, new AuthenticationContextSerializer(), pluggableAuthenticatorChain, new ServiceAccountAuthenticator(serviceAccountService, nodeName, meterRegistry), new OAuth2TokenAuthenticator(tokenService, meterRegistry), new ApiKeyAuthenticator(apiKeyService, nodeName, meterRegistry), new RealmsAuthenticator(this.numInvalidation, this.lastSuccessfulAuthCache, meterRegistry));
    }

    public void authenticate(HttpPreRequest request, ActionListener<Authentication> authenticationListener) {
        this.authenticate(request, true, authenticationListener);
    }

    public void authenticate(HttpPreRequest request, boolean allowAnonymous, ActionListener<Authentication> authenticationListener) {
        Authenticator.Context context = new Authenticator.Context(this.threadContext, new AuditableHttpRequest(this.auditTrailService.get(), this.failureHandler, this.threadContext, request), null, allowAnonymous, this.realms);
        this.authenticate(context, authenticationListener);
    }

    public void authenticate(String action, TransportRequest transportRequest, User fallbackUser, ActionListener<Authentication> listener) {
        Objects.requireNonNull(fallbackUser, "fallback user may not be null");
        Authenticator.Context context = new Authenticator.Context(this.threadContext, new AuditableTransportRequest(this.auditTrailService.get(), this.failureHandler, this.threadContext, action, transportRequest), fallbackUser, false, this.realms);
        this.authenticate(context, listener);
    }

    public void authenticate(String action, TransportRequest transportRequest, boolean allowAnonymous, ActionListener<Authentication> listener) {
        Authenticator.Context context = new Authenticator.Context(this.threadContext, new AuditableTransportRequest(this.auditTrailService.get(), this.failureHandler, this.threadContext, action, transportRequest), null, allowAnonymous, this.realms);
        this.authenticate(context, listener);
    }

    public void authenticate(String action, TransportRequest transportRequest, AuthenticationToken token, ActionListener<Authentication> listener) {
        Authenticator.Context context = new Authenticator.Context(this.threadContext, new AuditableTransportRequest(this.auditTrailService.get(), this.failureHandler, this.threadContext, action, transportRequest), this.realms, token);
        this.authenticatorChain.authenticate(context, listener);
    }

    public void expire(String principal) {
        if (this.lastSuccessfulAuthCache != null) {
            this.numInvalidation.incrementAndGet();
            this.lastSuccessfulAuthCache.invalidate((Object)principal);
        }
    }

    public void expireAll() {
        if (this.lastSuccessfulAuthCache != null) {
            this.numInvalidation.incrementAndGet();
            this.lastSuccessfulAuthCache.invalidateAll();
        }
    }

    public void onSecurityIndexStateChange(ProjectId projectId, SecurityIndexManager.IndexState previousState, SecurityIndexManager.IndexState currentState) {
        if (this.lastSuccessfulAuthCache != null && (SecurityIndexManager.isMoveFromRedToNonRed(previousState, currentState) || SecurityIndexManager.isIndexDeleted(previousState, currentState) || !Objects.equals(previousState.indexUUID, currentState.indexUUID))) {
            this.expireAll();
        }
    }

    Authenticator.Context newContext(String action, TransportRequest request, AuthenticationToken authenticationToken) {
        return new Authenticator.Context(this.threadContext, new AuditableTransportRequest(this.auditTrailService.get(), this.failureHandler, this.threadContext, action, request), this.realms, authenticationToken);
    }

    void authenticate(Authenticator.Context context, ActionListener<Authentication> listener) {
        this.authenticatorChain.authenticate(context, listener);
    }

    long getNumInvalidation() {
        return this.numInvalidation.get();
    }

    public static void addSettings(List<Setting<?>> settings) {
        settings.add(AuthenticationServiceField.RUN_AS_ENABLED);
        settings.add(SUCCESS_AUTH_CACHE_ENABLED);
        settings.add(SUCCESS_AUTH_CACHE_MAX_SIZE);
        settings.add(SUCCESS_AUTH_CACHE_EXPIRE_AFTER_ACCESS);
    }

    static class AuditableHttpRequest
    extends AuditableRequest {
        private final HttpPreRequest request;
        private final String requestId;

        AuditableHttpRequest(AuditTrail auditTrail, AuthenticationFailureHandler failureHandler, ThreadContext threadContext, HttpPreRequest request) {
            super(auditTrail, failureHandler, threadContext);
            this.request = request;
            this.requestId = AuditUtil.generateRequestId(threadContext);
        }

        @Override
        void authenticationSuccess(Authentication authentication) {
        }

        @Override
        void realmAuthenticationFailed(AuthenticationToken token, String realm) {
            this.auditTrail.authenticationFailed(this.requestId, realm, token, this.request);
        }

        @Override
        ElasticsearchSecurityException tamperedRequest() {
            this.auditTrail.tamperedRequest(this.requestId, this.request);
            return new ElasticsearchSecurityException("rest request attempted to inject a user", new Object[0]);
        }

        @Override
        ElasticsearchSecurityException exceptionProcessingRequest(Exception e, @Nullable AuthenticationToken token) {
            if (token != null) {
                this.auditTrail.authenticationFailed(this.requestId, token, this.request);
            } else {
                this.auditTrail.authenticationFailed(this.requestId, this.request);
            }
            return this.failureHandler.exceptionProcessingRequest(this.request, e, this.threadContext);
        }

        @Override
        ElasticsearchSecurityException authenticationFailed(AuthenticationToken token) {
            this.auditTrail.authenticationFailed(this.requestId, token, this.request);
            return this.failureHandler.failedAuthentication(this.request, token, this.threadContext);
        }

        @Override
        ElasticsearchSecurityException anonymousAccessDenied() {
            this.auditTrail.anonymousAccessDenied(this.requestId, this.request);
            return this.failureHandler.missingToken(this.request, this.threadContext);
        }

        @Override
        ElasticsearchSecurityException runAsDenied(Authentication authentication, AuthenticationToken token) {
            this.auditTrail.runAsDenied(this.requestId, authentication, this.request, (AuthorizationEngine.AuthorizationInfo)AuthorizationEngine.EmptyAuthorizationInfo.INSTANCE);
            return this.failureHandler.failedAuthentication(this.request, token, this.threadContext);
        }

        public String toString() {
            return "rest request uri [" + this.request.uri() + "]";
        }
    }

    public static abstract class AuditableRequest {
        final AuditTrail auditTrail;
        final AuthenticationFailureHandler failureHandler;
        final ThreadContext threadContext;

        AuditableRequest(AuditTrail auditTrail, AuthenticationFailureHandler failureHandler, ThreadContext threadContext) {
            this.auditTrail = auditTrail;
            this.failureHandler = failureHandler;
            this.threadContext = threadContext;
        }

        abstract void realmAuthenticationFailed(AuthenticationToken var1, String var2);

        abstract ElasticsearchSecurityException tamperedRequest();

        abstract ElasticsearchSecurityException exceptionProcessingRequest(Exception var1, @Nullable AuthenticationToken var2);

        abstract ElasticsearchSecurityException authenticationFailed(AuthenticationToken var1);

        abstract ElasticsearchSecurityException anonymousAccessDenied();

        abstract ElasticsearchSecurityException runAsDenied(Authentication var1, AuthenticationToken var2);

        abstract void authenticationSuccess(Authentication var1);
    }

    static class AuditableTransportRequest
    extends AuditableRequest {
        private final String action;
        private final TransportRequest transportRequest;
        private final String requestId;

        AuditableTransportRequest(AuditTrail auditTrail, AuthenticationFailureHandler failureHandler, ThreadContext threadContext, String action, TransportRequest transportRequest) {
            super(auditTrail, failureHandler, threadContext);
            this.action = action;
            this.transportRequest = transportRequest;
            this.requestId = AuditUtil.getOrGenerateRequestId(threadContext);
        }

        @Override
        void authenticationSuccess(Authentication authentication) {
            this.auditTrail.authenticationSuccess(this.requestId, authentication, this.action, this.transportRequest);
        }

        @Override
        void realmAuthenticationFailed(AuthenticationToken token, String realm) {
            this.auditTrail.authenticationFailed(this.requestId, realm, token, this.action, this.transportRequest);
        }

        @Override
        ElasticsearchSecurityException tamperedRequest() {
            this.auditTrail.tamperedRequest(this.requestId, this.action, this.transportRequest);
            return new ElasticsearchSecurityException("failed to verify signed authentication information", new Object[0]);
        }

        @Override
        ElasticsearchSecurityException exceptionProcessingRequest(Exception e, @Nullable AuthenticationToken token) {
            if (token != null) {
                this.auditTrail.authenticationFailed(this.requestId, token, this.action, this.transportRequest);
            } else {
                this.auditTrail.authenticationFailed(this.requestId, this.action, this.transportRequest);
            }
            return this.failureHandler.exceptionProcessingRequest(this.transportRequest, this.action, e, this.threadContext);
        }

        @Override
        ElasticsearchSecurityException authenticationFailed(AuthenticationToken token) {
            this.auditTrail.authenticationFailed(this.requestId, token, this.action, this.transportRequest);
            return this.failureHandler.failedAuthentication(this.transportRequest, token, this.action, this.threadContext);
        }

        @Override
        ElasticsearchSecurityException anonymousAccessDenied() {
            this.auditTrail.anonymousAccessDenied(this.requestId, this.action, this.transportRequest);
            return this.failureHandler.missingToken(this.transportRequest, this.action, this.threadContext);
        }

        @Override
        ElasticsearchSecurityException runAsDenied(Authentication authentication, AuthenticationToken token) {
            this.auditTrail.runAsDenied(this.requestId, authentication, this.action, this.transportRequest, (AuthorizationEngine.AuthorizationInfo)AuthorizationEngine.EmptyAuthorizationInfo.INSTANCE);
            return this.failureHandler.failedAuthentication(this.transportRequest, token, this.action, this.threadContext);
        }

        public String toString() {
            return "transport request action [" + this.action + "]";
        }
    }
}

