/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.IOException;
import java.util.Iterator;
import java.util.function.ToIntFunction;
import org.elasticsearch.common.CheckedBiFunction;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.test.AbstractSerializationTestCase;
import org.elasticsearch.test.AbstractXContentTestCase;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public abstract class AbstractChunkedSerializingTestCase<T extends ChunkedToXContent & Writeable>
extends AbstractSerializationTestCase<T> {
    @Override
    protected AbstractXContentTestCase.XContentTester<T> createXContentTester() {
        return AbstractXContentTestCase.chunkedXContentTester((CheckedBiFunction<XContent, BytesReference, XContentParser, IOException>)((CheckedBiFunction)this::createParser), this::createXContextTestInstance, this.getToXContentParams(), this::doParseInstance);
    }

    @Override
    protected ToXContent asXContent(T instance) {
        return ChunkedToXContent.wrapAsToXContent(instance);
    }

    @Override
    protected T createXContextTestInstance(XContentType xContentType) {
        return (T)((ChunkedToXContent)this.createTestInstance());
    }

    protected abstract T doParseInstance(XContentParser var1) throws IOException;

    public static <T extends ChunkedToXContent> void assertChunkCount(T instance, ToIntFunction<T> expectedChunkCount) {
        AbstractChunkedSerializingTestCase.assertChunkCount(instance, ToXContent.EMPTY_PARAMS, expectedChunkCount);
    }

    public static <T extends ChunkedToXContent> void assertChunkCount(T instance, ToXContent.Params params, ToIntFunction<T> expectedChunkCount) {
        int chunkCount = 0;
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            if (instance.isFragment()) {
                builder.startObject();
            }
            Iterator iterator = instance.toXContentChunked(params);
            while (iterator.hasNext()) {
                ((ToXContent)iterator.next()).toXContent(builder, params);
                ++chunkCount;
            }
            if (instance.isFragment()) {
                builder.endObject();
            }
        }
        catch (IOException e) {
            AbstractChunkedSerializingTestCase.fail(e);
        }
        AbstractChunkedSerializingTestCase.assertEquals((long)expectedChunkCount.applyAsInt(instance), (long)chunkCount);
    }
}

