/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.core.Strings;
import org.elasticsearch.telemetry.InstrumentType;
import org.elasticsearch.telemetry.Measurement;
import org.elasticsearch.telemetry.Registration;
import org.elasticsearch.telemetry.metric.Instrument;

public class MetricRecorder<I> {
    private final Map<InstrumentType, RegisteredMetric<I>> metrics = new ConcurrentHashMap<InstrumentType, RegisteredMetric<I>>(InstrumentType.values().length);

    public MetricRecorder() {
        for (InstrumentType instrument : InstrumentType.values()) {
            this.metrics.put(instrument, new RegisteredMetric(new ConcurrentHashMap<String, Registration>(), new ConcurrentHashMap<String, List<Measurement>>(), new ConcurrentHashMap(), new CopyOnWriteArrayList<Runnable>()));
        }
    }

    public void register(I instrument, InstrumentType instrumentType, String name, String description, String unit) {
        this.metrics.get((Object)instrumentType).register(name, description, unit, instrument);
    }

    public void call(Instrument instrument, Number value, Map<String, Object> attributes) {
        this.call(InstrumentType.fromInstrument(instrument), instrument.getName(), value, attributes);
    }

    public void call(InstrumentType instrumentType, String name, Number value, Map<String, Object> attributes) {
        this.metrics.get((Object)instrumentType).call(name, new Measurement(value, attributes, instrumentType.isDouble));
    }

    public List<Measurement> getMeasurements(Instrument instrument) {
        return this.getMeasurements(InstrumentType.fromInstrument(instrument), instrument.getName());
    }

    public List<Measurement> getMeasurements(InstrumentType instrumentType, String name) {
        return this.metrics.get((Object)((Object)instrumentType)).called.getOrDefault(Objects.requireNonNull(name), Collections.emptyList());
    }

    public ArrayList<String> getRegisteredMetrics(InstrumentType instrumentType) {
        ArrayList<String> registeredMetrics = new ArrayList<String>();
        this.metrics.get((Object)((Object)instrumentType)).instruments.forEach((name, registration) -> registeredMetrics.add((String)name));
        return registeredMetrics;
    }

    public Registration getRegistration(Instrument instrument) {
        return this.metrics.get((Object)InstrumentType.fromInstrument(instrument)).registered().get(instrument.getName());
    }

    public I getInstrument(InstrumentType instrumentType, String name) {
        return this.metrics.get((Object)((Object)instrumentType)).instruments.get(name);
    }

    public void resetCalls() {
        this.metrics.forEach((it, rm) -> rm.called().clear());
    }

    public void collect() {
        this.metrics.forEach((it, rm) -> rm.callbacks().forEach(Runnable::run));
    }

    private record RegisteredMetric<I>(Map<String, Registration> registered, Map<String, List<Measurement>> called, Map<String, I> instruments, List<Runnable> callbacks) {
        void register(String name, String description, String unit, I instrument) {
            assert (!this.registered.containsKey(name)) : Strings.format((String)"unexpected [%s]: [%s][%s], already registered[%s]", (Object[])new Object[]{name, description, unit, this.registered.get(name)});
            this.registered.put(name, new Registration(name, description, unit));
            this.instruments.put(name, instrument);
            if (instrument instanceof Runnable) {
                Runnable callback = (Runnable)instrument;
                this.callbacks.add(callback);
            }
        }

        void call(String name, Measurement call) {
            assert (this.registered.containsKey(name)) : Strings.format((String)"call for unregistered metric [%s]: [%s]", (Object[])new Object[]{name, call});
            this.called.computeIfAbsent(Objects.requireNonNull(name), k -> new CopyOnWriteArrayList()).add(call);
        }
    }
}

