/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Base64;
import org.apache.lucene.tests.mockfile.ExtrasFS;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.repositories.blobstore.RepositoryFileType;
import org.elasticsearch.test.ESTestCase;

public class BlobStoreCorruptionUtils {
    private static final Logger logger = LogManager.getLogger(BlobStoreCorruptionUtils.class);

    public static Path corruptRandomFile(Path repositoryRootPath) throws IOException {
        RepositoryFileType corruptedFileType = BlobStoreCorruptionUtils.getRandomCorruptibleFileType();
        Path corruptedFile = BlobStoreCorruptionUtils.getRandomFileToCorrupt(repositoryRootPath, corruptedFileType);
        if (ESTestCase.randomBoolean()) {
            logger.info("--> deleting [{}]", new Object[]{corruptedFile});
            Files.delete(corruptedFile);
        } else {
            BlobStoreCorruptionUtils.corruptFileContents(corruptedFile);
        }
        return corruptedFile;
    }

    public static void corruptFileContents(Path fileToCorrupt) throws IOException {
        byte[] oldFileContents = Files.readAllBytes(fileToCorrupt);
        logger.info("--> contents of [{}] before corruption: [{}]", new Object[]{fileToCorrupt, Base64.getEncoder().encodeToString(oldFileContents)});
        byte[] newFileContents = new byte[ESTestCase.randomBoolean() ? oldFileContents.length : ESTestCase.between(0, oldFileContents.length)];
        System.arraycopy(oldFileContents, 0, newFileContents, 0, newFileContents.length);
        if (newFileContents.length == oldFileContents.length) {
            int corruptionPosition = ESTestCase.between(0, newFileContents.length - 1);
            newFileContents[corruptionPosition] = ESTestCase.randomValueOtherThan(oldFileContents[corruptionPosition], ESTestCase::randomByte);
            logger.info("--> updating byte at position [{}] from [{}] to [{}]", new Object[]{corruptionPosition, oldFileContents[corruptionPosition], newFileContents[corruptionPosition]});
        } else {
            logger.info("--> truncating file from length [{}] to length [{}]", new Object[]{oldFileContents.length, newFileContents.length});
        }
        Files.write(fileToCorrupt, newFileContents, new OpenOption[0]);
        logger.info("--> contents of [{}] after corruption: [{}]", new Object[]{fileToCorrupt, Base64.getEncoder().encodeToString(newFileContents)});
    }

    public static RepositoryFileType getRandomCorruptibleFileType() {
        return ESTestCase.randomValueOtherThanMany(t -> t == RepositoryFileType.ROOT_INDEX_N || t == RepositoryFileType.ROOT_INDEX_LATEST, () -> ESTestCase.randomFrom(RepositoryFileType.values()));
    }

    public static Path getRandomFileToCorrupt(final Path repositoryRootPath, final RepositoryFileType corruptedFileType) throws IOException {
        final ArrayList corruptibleFiles = new ArrayList();
        Files.walkFileTree(repositoryRootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path filePath, BasicFileAttributes attrs) throws IOException {
                if (!ExtrasFS.isExtra((String)filePath.getFileName().toString()) && RepositoryFileType.getRepositoryFileType(repositoryRootPath, filePath) == corruptedFileType) {
                    corruptibleFiles.add(filePath);
                }
                return super.visitFile(filePath, attrs);
            }
        });
        return (Path)ESTestCase.randomFrom(corruptibleFiles);
    }
}

