/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.tests.index.RandomIndexWriter;
import org.apache.lucene.tests.store.BaseDirectoryWrapper;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.lucene.index.ElasticsearchDirectoryReader;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.MockBigArrays;
import org.elasticsearch.common.util.MockPageCacheRecycler;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NameOrDefinition;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.codec.PerFieldMapperCodec;
import org.elasticsearch.index.codec.zstd.Zstd814StoredFieldsFormat;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fieldvisitor.LeafStoredFieldLoader;
import org.elasticsearch.index.fieldvisitor.StoredFieldLoader;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldTypeTestCase;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperMetrics;
import org.elasticsearch.index.mapper.MapperRegistry;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.NestedLookup;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.RootObjectMapperNamespaceValidator;
import org.elasticsearch.index.mapper.SourceFieldMetrics;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.query.support.NestedScope;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.indices.IndicesModule;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.TelemetryPlugin;
import org.elasticsearch.plugins.internal.InternalVectorFormatProviderPlugin;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.internal.SubSearchContext;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.lookup.SourceFilter;
import org.elasticsearch.search.lookup.SourceProvider;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortAndFormats;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.telemetry.TelemetryProvider;
import org.elasticsearch.test.FieldMaskingReader;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.hamcrest.Matchers;
import org.mockito.Mockito;

public abstract class MapperServiceTestCase
extends FieldTypeTestCase {
    protected static final Settings SETTINGS = Settings.builder().put("index.version.created", (VersionId)IndexVersion.current()).build();
    protected static final ToXContent.Params INCLUDE_DEFAULTS = new ToXContent.MapParams(Map.of("include_defaults", "true"));

    protected Collection<? extends Plugin> getPlugins() {
        return Collections.emptyList();
    }

    protected Settings getIndexSettings() {
        return SETTINGS;
    }

    protected final Settings.Builder getIndexSettingsBuilder() {
        return Settings.builder().put(this.getIndexSettings());
    }

    protected IndexAnalyzers createIndexAnalyzers(IndexSettings indexSettings) {
        return MapperServiceTestCase.createIndexAnalyzers();
    }

    protected static IndexAnalyzers createIndexAnalyzers() {
        return IndexAnalyzers.of(Map.of("default", new NamedAnalyzer("default", AnalyzerScope.INDEX, (Analyzer)new StandardAnalyzer())));
    }

    protected static String randomIndexOptions() {
        return MapperServiceTestCase.randomFrom("docs", "freqs", "positions", "offsets");
    }

    protected final DocumentMapper createDocumentMapper(XContentBuilder mappings, IndexMode indexMode) throws IOException {
        return switch (indexMode) {
            default -> throw new MatchException(null, null);
            case IndexMode.STANDARD, IndexMode.LOOKUP -> this.createDocumentMapper(mappings);
            case IndexMode.TIME_SERIES -> this.createTimeSeriesModeDocumentMapper(mappings);
            case IndexMode.LOGSDB -> this.createLogsModeDocumentMapper(mappings);
        };
    }

    protected final DocumentMapper createDocumentMapper(XContentBuilder mappings) throws IOException {
        return this.createMapperService(mappings).documentMapper();
    }

    protected final DocumentMapper createTimeSeriesModeDocumentMapper(XContentBuilder mappings) throws IOException {
        Settings settings = Settings.builder().put(IndexSettings.MODE.getKey(), "time_series").put(IndexMetadata.INDEX_ROUTING_PATH.getKey(), "uid").build();
        return this.createMapperService(settings, mappings).documentMapper();
    }

    protected final DocumentMapper createLogsModeDocumentMapper(XContentBuilder mappings) throws IOException {
        Settings settings = Settings.builder().put(IndexSettings.MODE.getKey(), IndexMode.LOGSDB.getName()).build();
        return this.createMapperService(settings, mappings).documentMapper();
    }

    protected final DocumentMapper createDocumentMapper(IndexVersion version, XContentBuilder mappings) throws IOException {
        return this.createMapperService(version, mappings).documentMapper();
    }

    protected final DocumentMapper createDocumentMapper(String mappings) throws IOException {
        MapperService mapperService = this.createMapperService(MapperServiceTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {})));
        MapperServiceTestCase.merge(mapperService, mappings);
        return mapperService.documentMapper();
    }

    public final MapperService createMapperService(XContentBuilder mappings) throws IOException {
        return this.createMapperService(this.getVersion(), mappings);
    }

    public final MapperService createSytheticSourceMapperService(XContentBuilder mappings) throws IOException {
        Settings settings = Settings.builder().put("index.mapping.source.mode", "synthetic").build();
        return this.createMapperService(this.getVersion(), settings, () -> true, mappings);
    }

    protected IndexVersion getVersion() {
        return IndexVersion.current();
    }

    protected final MapperService createMapperService(Settings settings, XContentBuilder mappings) throws IOException {
        return this.createMapperService(this.getVersion(), settings, () -> true, mappings);
    }

    protected final MapperService createMapperService(BooleanSupplier idFieldEnabled, XContentBuilder mappings) throws IOException {
        return this.createMapperService(this.getVersion(), this.getIndexSettings(), idFieldEnabled, mappings);
    }

    public final MapperService createMapperService(String mappings) throws IOException {
        MapperService mapperService = this.createMapperService(MapperServiceTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {})));
        MapperServiceTestCase.merge(mapperService, mappings);
        return mapperService;
    }

    protected final MapperService createMapperService(Settings settings, String mappings) throws IOException {
        MapperService mapperService = this.createMapperService(IndexVersion.current(), settings, () -> true, MapperServiceTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {})));
        MapperServiceTestCase.merge(mapperService, mappings);
        return mapperService;
    }

    protected final MapperService createMapperService(IndexVersion indexVersion, Settings settings, XContentBuilder mappings) throws IOException {
        MapperService mapperService = this.createMapperService(indexVersion, settings, () -> true, mappings);
        return mapperService;
    }

    protected final MapperService createMapperService(IndexVersion version, XContentBuilder mapping) throws IOException {
        return this.createMapperService(version, this.getIndexSettings(), () -> true, mapping);
    }

    protected final MapperService createMapperService(IndexVersion version, Settings settings, BooleanSupplier idFieldDataEnabled, XContentBuilder mapping) throws IOException {
        MapperService mapperService = this.createMapperService(version, settings, idFieldDataEnabled);
        return this.withMapping(mapperService, mapping);
    }

    protected final MapperService createMapperService(IndexVersion version, Settings settings, BooleanSupplier idFieldDataEnabled) {
        return new TestMapperServiceBuilder().indexVersion(version).settings(settings).idFieldDataEnabled(idFieldDataEnabled).build();
    }

    public MapperService createMapperServiceWithNamespaceValidator(String mappings, RootObjectMapperNamespaceValidator validator) throws IOException {
        MapperService mapperService = new TestMapperServiceBuilder().indexVersion(this.getVersion()).settings(this.getIndexSettings()).idFieldDataEnabled(() -> true).namespaceValidator(validator).build();
        MapperServiceTestCase.merge(mapperService, mappings);
        return mapperService;
    }

    protected final MapperService withMapping(MapperService mapperService, XContentBuilder mapping) throws IOException {
        MapperServiceTestCase.merge(mapperService, mapping);
        return mapperService;
    }

    protected <T> T compileScript(Script script, ScriptContext<T> context) {
        throw new UnsupportedOperationException("Cannot compile script " + Strings.toString((ToXContent)script));
    }

    protected static IndexSettings createIndexSettings(IndexVersion version, Settings settings) {
        return MapperServiceTestCase.createIndexSettings(version, settings, List.of());
    }

    protected static IndexSettings createIndexSettings(IndexVersion version, Settings settings, Collection<Setting<?>> pluginIndexSettings) {
        settings = MapperServiceTestCase.indexSettings(1, 0).put(settings).put("index.version.created", (VersionId)version).build();
        IndexMetadata meta = IndexMetadata.builder((String)"index").settings(settings).build();
        HashSet indexSettings = new HashSet(IndexScopedSettings.BUILT_IN_INDEX_SETTINGS);
        indexSettings.addAll(pluginIndexSettings);
        return new IndexSettings(meta, settings, new IndexScopedSettings(Settings.EMPTY, indexSettings));
    }

    protected MapperMetrics createTestMapperMetrics() {
        TelemetryProvider telemetryProvider = this.getPlugins().stream().filter(p -> p instanceof TelemetryPlugin).map(p -> ((TelemetryPlugin)p).getTelemetryProvider(Settings.EMPTY)).findFirst().orElse(TelemetryProvider.NOOP);
        return new MapperMetrics(new SourceFieldMetrics(telemetryProvider.getMeterRegistry(), new LongSupplier(this){
            private long value = 1L;

            @Override
            public long getAsLong() {
                return this.value++;
            }
        }));
    }

    protected static void withLuceneIndex(MapperService mapperService, CheckedConsumer<RandomIndexWriter, IOException> builder, CheckedConsumer<DirectoryReader, IOException> test) throws IOException {
        IndexWriterConfig iwc = new IndexWriterConfig(IndexShard.buildIndexAnalyzer((MapperService)mapperService)).setCodec((Codec)new PerFieldMapperCodec(Zstd814StoredFieldsFormat.Mode.BEST_SPEED, mapperService, BigArrays.NON_RECYCLING_INSTANCE));
        try (BaseDirectoryWrapper dir = MapperServiceTestCase.newDirectory();
             RandomIndexWriter iw = new RandomIndexWriter(MapperServiceTestCase.random(), (Directory)dir, iwc);){
            builder.accept((Object)iw);
            try (DirectoryReader reader = iw.getReader();){
                test.accept((Object)reader);
            }
        }
    }

    public static SourceToParse source(CheckedConsumer<XContentBuilder, IOException> build) throws IOException {
        return MapperServiceTestCase.source("1", build, null);
    }

    protected static SourceToParse source(@Nullable String id, CheckedConsumer<XContentBuilder, IOException> build, @Nullable String routing) throws IOException {
        return MapperServiceTestCase.source(id, build, routing, Map.of());
    }

    protected static SourceToParse source(@Nullable String id, CheckedConsumer<XContentBuilder, IOException> build, @Nullable String routing, Map<String, String> dynamicTemplates) throws IOException {
        XContentBuilder builder = JsonXContent.contentBuilder().startObject();
        build.accept((Object)builder);
        builder.endObject();
        return new SourceToParse(id, BytesReference.bytes((XContentBuilder)builder), XContentType.JSON, routing, dynamicTemplates, null);
    }

    protected static SourceToParse source(String source) {
        return new SourceToParse("1", (BytesReference)new BytesArray(source), XContentType.JSON);
    }

    protected static void merge(MapperService mapperService, XContentBuilder mapping) throws IOException {
        MapperServiceTestCase.merge(mapperService, MapperService.MergeReason.MAPPING_UPDATE, mapping);
    }

    protected static void merge(MapperService mapperService, String mapping) throws IOException {
        mapperService.merge(null, new CompressedXContent(mapping), MapperService.MergeReason.MAPPING_UPDATE);
    }

    protected static void merge(MapperService mapperService, MapperService.MergeReason reason, String mapping) throws IOException {
        mapperService.merge(null, new CompressedXContent(mapping), reason);
    }

    protected static void merge(MapperService mapperService, MapperService.MergeReason reason, XContentBuilder mapping) throws IOException {
        mapperService.merge(null, new CompressedXContent(BytesReference.bytes((XContentBuilder)mapping)), reason);
    }

    protected static XContentBuilder topMapping(CheckedConsumer<XContentBuilder, IOException> buildFields) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject("_doc");
        buildFields.accept((Object)builder);
        return builder.endObject().endObject();
    }

    protected static XContentBuilder mappingNoSubobjects(CheckedConsumer<XContentBuilder, IOException> buildFields) throws IOException {
        return MapperServiceTestCase.mappingWithSubobjects(buildFields, "false");
    }

    protected static XContentBuilder mappingWithSubobjects(CheckedConsumer<XContentBuilder, IOException> buildFields, String subobjects) throws IOException {
        return MapperServiceTestCase.topMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)xContentBuilder -> {
            xContentBuilder.field("subobjects", subobjects);
            xContentBuilder.startObject("properties");
            buildFields.accept(xContentBuilder);
            xContentBuilder.endObject();
        }));
    }

    public static XContentBuilder mapping(CheckedConsumer<XContentBuilder, IOException> buildFields) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject("_doc").startObject("properties");
        buildFields.accept((Object)builder);
        return builder.endObject().endObject().endObject();
    }

    protected static XContentBuilder dynamicMapping(Mapping dynamicMapping) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
        dynamicMapping.toXContent(builder, ToXContent.EMPTY_PARAMS);
        return builder.endObject();
    }

    protected static XContentBuilder fieldMapping(CheckedConsumer<XContentBuilder, IOException> buildField) throws IOException {
        return MapperServiceTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("field");
            buildField.accept(b);
            b.endObject();
        }));
    }

    protected static XContentBuilder runtimeFieldMapping(CheckedConsumer<XContentBuilder, IOException> buildField) throws IOException {
        return MapperServiceTestCase.runtimeMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("field");
            buildField.accept(b);
            b.endObject();
        }));
    }

    protected static XContentBuilder runtimeMapping(CheckedConsumer<XContentBuilder, IOException> buildFields) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject("_doc").startObject("runtime");
        buildFields.accept((Object)builder);
        return builder.endObject().endObject().endObject();
    }

    private AggregationContext aggregationContext(final ValuesSourceRegistry valuesSourceRegistry, final MapperService mapperService, final IndexSearcher searcher, final Query query, final Supplier<SearchLookup> lookupSupplier) {
        return new AggregationContext(){
            private final CircuitBreaker breaker = (CircuitBreaker)Mockito.mock(CircuitBreaker.class);

            public IndexSearcher searcher() {
                return searcher;
            }

            public Aggregator profileIfEnabled(Aggregator agg) throws IOException {
                return agg;
            }

            public boolean profiling() {
                return false;
            }

            public Query query() {
                return query;
            }

            public long nowInMillis() {
                return 0L;
            }

            public Analyzer getNamedAnalyzer(String analyzer) {
                return null;
            }

            public Analyzer buildCustomAnalyzer(IndexSettings indexSettings, boolean normalizer, NameOrDefinition tokenizer, List<NameOrDefinition> charFilters, List<NameOrDefinition> tokenFilters) {
                return null;
            }

            public SearchLookup lookup() {
                return (SearchLookup)lookupSupplier.get();
            }

            public ValuesSourceRegistry getValuesSourceRegistry() {
                return valuesSourceRegistry;
            }

            public IndexSettings getIndexSettings() {
                throw new UnsupportedOperationException();
            }

            public ClusterSettings getClusterSettings() {
                throw new UnsupportedOperationException();
            }

            public MappedFieldType getFieldType(String path) {
                return mapperService.fieldType(path);
            }

            public Set<String> getMatchingFieldNames(String pattern) {
                throw new UnsupportedOperationException();
            }

            public <FactoryType> FactoryType compile(Script script, ScriptContext<FactoryType> context) {
                return MapperServiceTestCase.this.compileScript(script, context);
            }

            public Optional<SortAndFormats> buildSort(List<SortBuilder<?>> sortBuilders) throws IOException {
                throw new UnsupportedOperationException();
            }

            public Query buildQuery(QueryBuilder builder) throws IOException {
                throw new UnsupportedOperationException();
            }

            public Query filterQuery(Query query2) {
                throw new UnsupportedOperationException();
            }

            protected IndexFieldData<?> buildFieldData(MappedFieldType ft) {
                return ft.fielddataBuilder(FieldDataContext.noRuntimeFields((String)"test")).build((IndexFieldDataCache)new IndexFieldDataCache.None(), (CircuitBreakerService)new NoneCircuitBreakerService());
            }

            public BigArrays bigArrays() {
                return new MockBigArrays((PageCacheRecycler)new MockPageCacheRecycler(Settings.EMPTY), (CircuitBreakerService)new NoneCircuitBreakerService());
            }

            public NestedLookup nestedLookup() {
                throw new UnsupportedOperationException();
            }

            public NestedScope nestedScope() {
                throw new UnsupportedOperationException();
            }

            public SubSearchContext subSearchContext() {
                throw new UnsupportedOperationException();
            }

            public void addReleasable(Aggregator aggregator) {
            }

            public void removeReleasable(Aggregator aggregator) {
            }

            public int maxBuckets() {
                return Integer.MAX_VALUE;
            }

            public BitsetFilterCache bitsetFilterCache() {
                throw new UnsupportedOperationException();
            }

            public BucketedSort buildBucketedSort(SortBuilder<?> sort, int size, BucketedSort.ExtraData values) throws IOException {
                throw new UnsupportedOperationException();
            }

            public int shardRandomSeed() {
                throw new UnsupportedOperationException();
            }

            public long getRelativeTimeInMillis() {
                return 0L;
            }

            public boolean isCancelled() {
                return false;
            }

            public CircuitBreaker breaker() {
                return this.breaker;
            }

            public Analyzer getIndexAnalyzer(Function<String, NamedAnalyzer> unindexedFieldAnalyzer) {
                throw new UnsupportedOperationException();
            }

            public boolean isCacheable() {
                throw new UnsupportedOperationException();
            }

            public boolean enableRewriteToFilterByFilter() {
                throw new UnsupportedOperationException();
            }

            public boolean isInSortOrderExecutionRequired() {
                return false;
            }

            public Set<String> sourcePath(String fullName) {
                return Set.of(fullName);
            }

            public void close() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected final void withAggregationContext(MapperService mapperService, List<SourceToParse> docs, CheckedConsumer<AggregationContext, IOException> test) throws IOException {
        this.withAggregationContext(mapperService, docs, test, () -> {
            throw new UnsupportedOperationException();
        });
    }

    protected final void withAggregationContext(MapperService mapperService, List<SourceToParse> docs, CheckedConsumer<AggregationContext, IOException> test, Supplier<SearchLookup> lookupSupplier) throws IOException {
        this.withAggregationContext(null, mapperService, docs, null, test, lookupSupplier);
    }

    protected final void withAggregationContext(ValuesSourceRegistry valuesSourceRegistry, MapperService mapperService, List<SourceToParse> docs, Query query, CheckedConsumer<AggregationContext, IOException> test) throws IOException {
        this.withAggregationContext(valuesSourceRegistry, mapperService, docs, query, test, () -> {
            throw new UnsupportedOperationException();
        });
    }

    protected final void withAggregationContext(ValuesSourceRegistry valuesSourceRegistry, MapperService mapperService, List<SourceToParse> docs, Query query, CheckedConsumer<AggregationContext, IOException> test, Supplier<SearchLookup> lookupSupplier) throws IOException {
        MapperServiceTestCase.withLuceneIndex(mapperService, (CheckedConsumer<RandomIndexWriter, IOException>)((CheckedConsumer)writer -> {
            for (SourceToParse doc : docs) {
                writer.addDocuments((Iterable)mapperService.documentMapper().parse(doc).docs());
            }
        }), (CheckedConsumer<DirectoryReader, IOException>)((CheckedConsumer)reader -> test.accept((Object)this.aggregationContext(valuesSourceRegistry, mapperService, MapperServiceTestCase.newSearcher((IndexReader)reader), query, lookupSupplier))));
    }

    protected SearchExecutionContext createSearchExecutionContext(MapperService mapperService) {
        return this.createSearchExecutionContext(mapperService, null, Settings.EMPTY);
    }

    public final SearchExecutionContext createSearchExecutionContext(MapperService mapperService, IndexSearcher searcher) {
        return this.createSearchExecutionContext(mapperService, searcher, Settings.EMPTY);
    }

    protected SearchExecutionContext createSearchExecutionContext(MapperService mapperService, IndexSearcher searcher, Settings settings) {
        Settings mergedSettings = Settings.builder().put(mapperService.getIndexSettings().getSettings()).put(settings).build();
        IndexMetadata indexMetadata = IndexMetadata.builder((IndexMetadata)mapperService.getIndexSettings().getIndexMetadata()).settings(mergedSettings).build();
        IndexSettings indexSettings = new IndexSettings(indexMetadata, Settings.EMPTY);
        SimilarityService similarityService = new SimilarityService(indexSettings, null, Map.of());
        long nowInMillis = MapperServiceTestCase.randomNonNegativeLong();
        return new SearchExecutionContext(0, 0, indexSettings, new BitsetFilterCache(indexSettings, BitsetFilterCache.Listener.NOOP), (ft, fdc) -> ft.fielddataBuilder(fdc).build((IndexFieldDataCache)new IndexFieldDataCache.None(), (CircuitBreakerService)new NoneCircuitBreakerService()), mapperService, mapperService.mappingLookup(), similarityService, this::compileScript, this.parserConfig(), this.writableRegistry(), null, searcher, () -> nowInMillis, null, null, () -> true, null, Collections.emptyMap(), MapperMetrics.NOOP);
    }

    protected TriFunction<MappedFieldType, Supplier<SearchLookup>, MappedFieldType.FielddataOperation, IndexFieldData<?>> fieldDataLookup(MapperService mapperService) {
        return this.fieldDataLookup(arg_0 -> ((MappingLookup)mapperService.mappingLookup()).sourcePaths(arg_0));
    }

    protected TriFunction<MappedFieldType, Supplier<SearchLookup>, MappedFieldType.FielddataOperation, IndexFieldData<?>> fieldDataLookup(Function<String, Set<String>> sourcePathsLookup) {
        return (mft, lookupSource, fdo) -> mft.fielddataBuilder(new FieldDataContext("test", null, lookupSource, sourcePathsLookup, fdo)).build((IndexFieldDataCache)new IndexFieldDataCache.None(), (CircuitBreakerService)new NoneCircuitBreakerService());
    }

    protected RandomIndexWriter indexWriterForSyntheticSource(Directory directory) throws IOException {
        return new RandomIndexWriter(MapperServiceTestCase.random(), directory, (Analyzer)new StandardAnalyzer());
    }

    protected final String syntheticSource(DocumentMapper mapper, CheckedConsumer<XContentBuilder, IOException> build) throws IOException {
        return this.syntheticSource(mapper, null, build);
    }

    protected final String syntheticSource(DocumentMapper mapper, @Nullable SourceFilter sourceFilter, CheckedConsumer<XContentBuilder, IOException> build) throws IOException {
        try (BaseDirectoryWrapper directory = MapperServiceTestCase.newDirectory();){
            String string;
            block12: {
                RandomIndexWriter iw = this.indexWriterForSyntheticSource((Directory)directory);
                ParsedDocument doc = mapper.parse(MapperServiceTestCase.source(build));
                doc.updateSeqID(0L, 0L);
                doc.version().setLongValue(0L);
                iw.addDocuments((Iterable)doc.docs());
                iw.close();
                DirectoryReader indexReader = MapperServiceTestCase.wrapInMockESDirectoryReader(DirectoryReader.open((Directory)directory));
                try {
                    String syntheticSourceFiltered = MapperServiceTestCase.syntheticSource(mapper, sourceFilter, (IndexReader)indexReader, doc.docs().size() - 1);
                    String syntheticSource = MapperServiceTestCase.syntheticSource(mapper, null, (IndexReader)indexReader, doc.docs().size() - 1);
                    this.roundTripSyntheticSource(mapper, syntheticSource, indexReader);
                    string = syntheticSourceFiltered;
                    if (indexReader == null) break block12;
                }
                catch (Throwable throwable) {
                    if (indexReader != null) {
                        try {
                            indexReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                indexReader.close();
            }
            return string;
        }
    }

    private void roundTripSyntheticSource(DocumentMapper mapper, String syntheticSource, DirectoryReader reader) throws IOException {
        try (BaseDirectoryWrapper roundTripDirectory = MapperServiceTestCase.newDirectory();){
            RandomIndexWriter roundTripIw = this.indexWriterForSyntheticSource((Directory)roundTripDirectory);
            ParsedDocument doc = mapper.parse(new SourceToParse("1", (BytesReference)new BytesArray(syntheticSource), XContentType.JSON));
            doc.updateSeqID(0L, 0L);
            doc.version().setLongValue(0L);
            roundTripIw.addDocuments((Iterable)doc.docs());
            roundTripIw.close();
            try (DirectoryReader roundTripReader = MapperServiceTestCase.wrapInMockESDirectoryReader(DirectoryReader.open((Directory)roundTripDirectory));){
                String roundTripSyntheticSource = MapperServiceTestCase.syntheticSource(mapper, (IndexReader)roundTripReader, doc.docs().size() - 1);
                MapperServiceTestCase.assertThat(roundTripSyntheticSource, Matchers.equalTo((Object)syntheticSource));
                this.validateRoundTripReader(syntheticSource, reader, roundTripReader);
            }
        }
    }

    protected static String syntheticSource(DocumentMapper mapper, IndexReader reader, int docId) throws IOException {
        return MapperServiceTestCase.syntheticSource(mapper, null, reader, docId);
    }

    protected static String syntheticSource(DocumentMapper mapper, SourceFilter filter, IndexReader reader, int docId) throws IOException {
        String synthetic2;
        LeafReader leafReader = MapperServiceTestCase.getOnlyLeafReader((IndexReader)reader);
        SourceProvider provider = SourceProvider.fromLookup((MappingLookup)mapper.mappers(), (SourceFilter)filter, (SourceFieldMetrics)SourceFieldMetrics.NOOP);
        Source source = provider.getSource(leafReader.getContext(), docId);
        String synthetic1 = source.internalSourceRef().utf8ToString();
        XContent xContent = source.sourceContentType().xContent();
        int[] docIds = new int[]{docId};
        SourceLoader.Synthetic sourceLoader = new SourceLoader.Synthetic(filter, () -> mapper.mapping().syntheticFieldLoader(filter), SourceFieldMetrics.NOOP, mapper.mapping().ignoredSourceFormat());
        SourceLoader.Leaf sourceLeafLoader = sourceLoader.leaf(MapperServiceTestCase.getOnlyLeafReader((IndexReader)reader), docIds);
        LeafStoredFieldLoader storedFieldLoader = StoredFieldLoader.create((boolean)false, (Set)sourceLoader.requiredStoredFields()).getLoader(leafReader.getContext(), docIds);
        storedFieldLoader.advanceTo(docId);
        try (XContentBuilder b = new XContentBuilder(xContent, (OutputStream)new ByteArrayOutputStream());){
            sourceLeafLoader.write(storedFieldLoader, docId, b);
            synthetic2 = BytesReference.bytes((XContentBuilder)b).utf8ToString();
        }
        MapperServiceTestCase.assertThat(synthetic2, Matchers.equalTo((Object)synthetic1));
        return synthetic1;
    }

    protected void validateRoundTripReader(String syntheticSource, DirectoryReader reader, DirectoryReader roundTripReader) throws IOException {
        this.assertReaderEquals("round trip " + syntheticSource, (IndexReader)new FieldMaskingReader(Set.of("_recovery_source", "_recovery_source_size"), reader), (IndexReader)new FieldMaskingReader(Set.of("_recovery_source", "_recovery_source_size"), roundTripReader));
    }

    protected static DirectoryReader wrapInMockESDirectoryReader(DirectoryReader directoryReader) throws IOException {
        return ElasticsearchDirectoryReader.wrap((DirectoryReader)directoryReader, (ShardId)new ShardId(new Index("index", "_na_"), 0));
    }

    protected class TestMapperServiceBuilder {
        private IndexVersion indexVersion;
        private Settings settings;
        private BooleanSupplier idFieldDataEnabled;
        private ScriptCompiler scriptCompiler;
        private MapperMetrics mapperMetrics;
        private boolean applyDefaultMapping;
        private RootObjectMapperNamespaceValidator namespaceValidator;

        public TestMapperServiceBuilder() {
            this.indexVersion = MapperServiceTestCase.this.getVersion();
            this.settings = MapperServiceTestCase.this.getIndexSettings();
            this.idFieldDataEnabled = () -> true;
            this.scriptCompiler = MapperServiceTestCase.this::compileScript;
            this.mapperMetrics = MapperMetrics.NOOP;
            this.applyDefaultMapping = true;
        }

        public TestMapperServiceBuilder indexVersion(IndexVersion indexVersion) {
            this.indexVersion = indexVersion;
            return this;
        }

        public TestMapperServiceBuilder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public TestMapperServiceBuilder idFieldDataEnabled(BooleanSupplier idFieldDataEnabled) {
            this.idFieldDataEnabled = idFieldDataEnabled;
            return this;
        }

        public TestMapperServiceBuilder mapperMetrics(MapperMetrics mapperMetrics) {
            this.mapperMetrics = mapperMetrics;
            return this;
        }

        public TestMapperServiceBuilder applyDefaultMapping(boolean applyDefaultMapping) {
            this.applyDefaultMapping = applyDefaultMapping;
            return this;
        }

        public TestMapperServiceBuilder namespaceValidator(RootObjectMapperNamespaceValidator validator) {
            this.namespaceValidator = validator;
            return this;
        }

        public MapperService build() {
            Collection<? extends Plugin> plugins = MapperServiceTestCase.this.getPlugins();
            List<Setting<?>> pluginIndexSettings = plugins.stream().flatMap(plugin -> plugin.getSettings().stream()).filter(Setting::hasIndexScope).toList();
            IndexSettings indexSettings = MapperServiceTestCase.createIndexSettings(this.indexVersion, this.settings, pluginIndexSettings);
            SimilarityService similarityService = new SimilarityService(indexSettings, null, Map.of());
            MapperRegistry mapperRegistry = new IndicesModule(plugins.stream().filter(p -> p instanceof MapperPlugin).map(p -> (MapperPlugin)p).collect(Collectors.toList()), plugins.stream().filter(p -> p instanceof InternalVectorFormatProviderPlugin).map(p -> (InternalVectorFormatProviderPlugin)p).collect(Collectors.toList()), this.namespaceValidator).getMapperRegistry();
            BitsetFilterCache bitsetFilterCache = new BitsetFilterCache(indexSettings, BitsetFilterCache.Listener.NOOP);
            MapperService mapperService = new MapperService(() -> TransportVersion.current(), indexSettings, MapperServiceTestCase.this.createIndexAnalyzers(indexSettings), MapperServiceTestCase.this.parserConfig(), similarityService, mapperRegistry, () -> {
                throw new UnsupportedOperationException();
            }, indexSettings.getMode().buildIdFieldMapper(this.idFieldDataEnabled), this.scriptCompiler, arg_0 -> ((BitsetFilterCache)bitsetFilterCache).getBitSetProducer(arg_0), this.mapperMetrics);
            if (this.applyDefaultMapping && indexSettings.getMode().getDefaultMapping(indexSettings) != null) {
                mapperService.merge(null, indexSettings.getMode().getDefaultMapping(indexSettings), MapperService.MergeReason.MAPPING_UPDATE);
            }
            return mapperService;
        }
    }
}

