/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http;

import com.sun.net.httpserver.HttpsConfigurator;
import java.io.IOException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509ExtendedKeyManager;
import org.elasticsearch.common.ssl.KeyStoreUtil;
import org.elasticsearch.common.ssl.PemUtils;
import org.elasticsearch.core.SuppressForbidden;

@SuppressForbidden(reason="Implements com.sun class")
public class PemHttpsConfigurator
extends HttpsConfigurator {
    public PemHttpsConfigurator(Path certificate, Path key, char[] keyPassword) throws GeneralSecurityException, IOException {
        super(PemHttpsConfigurator.buildContext(certificate, key, keyPassword));
    }

    private static SSLContext buildContext(Path certPath, Path keyPath, char[] keyPassword) throws GeneralSecurityException, IOException {
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        PrivateKey privateKey = PemUtils.readPrivateKey((Path)keyPath, () -> keyPassword);
        List certificates = PemUtils.readCertificates(List.of(certPath));
        X509ExtendedKeyManager keyManager = KeyStoreUtil.createKeyManager((Certificate[])((Certificate[])certificates.toArray(Certificate[]::new)), (PrivateKey)privateKey, (char[])keyPassword);
        sslContext.init(new KeyManager[]{keyManager}, null, null);
        return sslContext;
    }
}

