/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.bootstrap;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.bootstrap.TestBuildInfo;
import org.elasticsearch.bootstrap.TestBuildInfoParser;
import org.elasticsearch.bootstrap.TestScopeResolver;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.entitlement.bootstrap.EntitlementBootstrap;
import org.elasticsearch.entitlement.bootstrap.FilesEntitlementsValidation;
import org.elasticsearch.entitlement.bootstrap.HardcodedEntitlements;
import org.elasticsearch.entitlement.bootstrap.TestPathLookup;
import org.elasticsearch.entitlement.initialization.EntitlementInitialization;
import org.elasticsearch.entitlement.runtime.policy.PathLookup;
import org.elasticsearch.entitlement.runtime.policy.Policy;
import org.elasticsearch.entitlement.runtime.policy.PolicyManager;
import org.elasticsearch.entitlement.runtime.policy.PolicyParser;
import org.elasticsearch.entitlement.runtime.policy.TestPolicyManager;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.plugins.PluginDescriptor;

public class TestEntitlementBootstrap {
    private static final Logger logger = LogManager.getLogger(TestEntitlementBootstrap.class);
    private static TestPathLookup TEST_PATH_LOOKUP;
    private static TestPolicyManager POLICY_MANAGER;

    public static void bootstrap(Path tempDir) throws IOException {
        if (!TestEntitlementBootstrap.isEnabledForTests()) {
            return;
        }
        assert (POLICY_MANAGER == null && TEST_PATH_LOOKUP == null) : "Test entitlement bootstrap called multiple times";
        TEST_PATH_LOOKUP = new TestPathLookup(tempDir);
        POLICY_MANAGER = TestEntitlementBootstrap.createPolicyManager(TEST_PATH_LOOKUP);
        TestEntitlementBootstrap.loadAgent(POLICY_MANAGER, TEST_PATH_LOOKUP);
    }

    public static boolean isEnabledForTests() {
        return Booleans.parseBoolean((String)System.getProperty("es.entitlement.enableForTests", "false"));
    }

    static TestPolicyManager testPolicyManager() {
        return POLICY_MANAGER;
    }

    static TestPathLookup testPathLookup() {
        return TEST_PATH_LOOKUP;
    }

    private static void loadAgent(PolicyManager policyManager, PathLookup pathLookup) {
        logger.debug("Loading entitlement agent");
        EntitlementInitialization.initializeArgs = new EntitlementInitialization.InitializeArgs(pathLookup, Set.of(), policyManager);
        EntitlementBootstrap.loadAgent((String)EntitlementBootstrap.findAgentJar(), (String)EntitlementInitialization.class.getName());
    }

    private static TestPolicyManager createPolicyManager(PathLookup pathLookup) throws IOException {
        List<TestBuildInfo> pluginsTestBuildInfo = TestBuildInfoParser.parseAllPluginTestBuildInfo();
        TestBuildInfo serverTestBuildInfo = TestBuildInfoParser.parseServerTestBuildInfo();
        List<String> pluginNames = pluginsTestBuildInfo.stream().map(TestBuildInfo::component).toList();
        List<PluginDescriptor> pluginDescriptors = TestEntitlementBootstrap.parsePluginsDescriptors(pluginNames);
        Set<String> modularPlugins = pluginDescriptors.stream().filter(PluginDescriptor::isModular).map(PluginDescriptor::getName).collect(Collectors.toSet());
        Function<Class<?>, PolicyManager.PolicyScope> scopeResolver = TestScopeResolver.createScopeResolver(serverTestBuildInfo, pluginsTestBuildInfo, modularPlugins);
        List<TestPluginData> pluginsData = pluginDescriptors.stream().map(descriptor -> new TestPluginData(descriptor.getName(), descriptor.isModular(), false)).toList();
        Map<String, Policy> pluginPolicies = TestEntitlementBootstrap.parsePluginsPolicies(pluginsData);
        String separator = System.getProperty("path.separator");
        String classPathProperty = System.getProperty("java.class.path");
        Set classPathEntries = classPathProperty == null ? Set.of() : (Set)Arrays.stream(classPathProperty.split(separator)).map(x$0 -> PathUtils.get((String)x$0, (String[])new String[0])).collect(Collectors.toCollection(TreeSet::new));
        FilesEntitlementsValidation.validate(pluginPolicies, (PathLookup)pathLookup);
        String testOnlyPathString = System.getenv("es.entitlement.testOnlyPath");
        Set testOnlyClassPath = testOnlyPathString == null ? Set.of() : (Set)Arrays.stream(testOnlyPathString.split(separator)).map(x$0 -> PathUtils.get((String)x$0, (String[])new String[0])).map(Path::toUri).collect(Collectors.toCollection(TreeSet::new));
        return new TestPolicyManager(HardcodedEntitlements.serverPolicy(null, null), HardcodedEntitlements.agentEntitlements(), pluginPolicies, scopeResolver, pathLookup, classPathEntries, testOnlyClassPath);
    }

    private static Map<String, Policy> parsePluginsPolicies(List<TestPluginData> pluginsData) {
        HashMap<String, Policy> policies = new HashMap<String, Policy>();
        for (TestPluginData pluginData : pluginsData) {
            String pluginName = pluginData.pluginName();
            String resourceName = Strings.format((String)"META-INF/es-plugins/%s/entitlement-policy.yaml", (Object[])new Object[]{pluginName});
            URL resource = EntitlementInitialization.class.getClassLoader().getResource(resourceName);
            if (resource == null) continue;
            try {
                InputStream inputStream = TestEntitlementBootstrap.getStream(resource);
                try {
                    policies.put(pluginName, new PolicyParser(inputStream, pluginName, pluginData.isExternalPlugin()).parsePolicy());
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException(Strings.format((String)"Cannot read policy for plugin [%s]", (Object[])new Object[]{pluginName}), e);
            }
        }
        return policies;
    }

    private static List<PluginDescriptor> parsePluginsDescriptors(List<String> pluginNames) {
        ArrayList<PluginDescriptor> descriptors = new ArrayList<PluginDescriptor>();
        for (String pluginName : pluginNames) {
            String resourceName = Strings.format((String)"META-INF/es-plugins/%s/plugin-descriptor.properties", (Object[])new Object[]{pluginName});
            URL resource = EntitlementInitialization.class.getClassLoader().getResource(resourceName);
            if (resource == null) continue;
            try {
                InputStream inputStream = TestEntitlementBootstrap.getStream(resource);
                try {
                    descriptors.add(PluginDescriptor.readInternalDescriptorFromStream((InputStream)inputStream));
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException(Strings.format((String)"Cannot read descriptor for plugin [%s]", (Object[])new Object[]{pluginName}), e);
            }
        }
        return descriptors;
    }

    @SuppressForbidden(reason="URLs from class loader")
    private static InputStream getStream(URL resource) throws IOException {
        return resource.openStream();
    }

    private record TestPluginData(String pluginName, boolean isModular, boolean isExternalPlugin) {
    }
}

