/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datageneration.queries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.elasticsearch.datageneration.Mapping;

public class MappingPredicates {
    private final Mapping mapping;

    public MappingPredicates(Mapping mapping) {
        this.mapping = mapping;
    }

    private List<PathMapping> getPathMapping(String path) {
        String[] parts = path.split("\\.");
        ArrayList<PathMapping> result = new ArrayList<PathMapping>();
        for (int i = 0; i < parts.length; ++i) {
            String pathToHere = String.join((CharSequence)".", Arrays.copyOfRange(parts, 0, i + 1));
            Map<String, Object> fieldMapping = this.mapping.lookup().get(pathToHere);
            if (fieldMapping == null) break;
            result.add(new PathMapping(pathToHere, fieldMapping));
        }
        return result;
    }

    public List<String> getNestedPathPrefixes(String fullPath) {
        return this.getPathMapping(fullPath).stream().filter(pm -> "nested".equals(pm.mapping().get("type"))).map(PathMapping::path).toList();
    }

    public boolean inNestedContext(String fullPath) {
        return this.getPathMapping(fullPath).stream().anyMatch(pm -> "nested".equals(pm.mapping().get("type")));
    }

    public boolean isRuntimeField(String path) {
        Map topLevelMapping = (Map)this.mapping.raw().get("_doc");
        boolean inRuntimeContext = "runtime".equals(topLevelMapping.get("dynamic"));
        for (PathMapping pm : this.getPathMapping(path)) {
            if (!pm.mapping().containsKey("dynamic")) continue;
            inRuntimeContext = "runtime".equals(pm.mapping().get("dynamic"));
        }
        return inRuntimeContext;
    }

    record PathMapping(String path, Map<String, Object> mapping) {
    }
}

