/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datageneration.matchers.source;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.datageneration.matchers.ListEqualMatcher;
import org.elasticsearch.datageneration.matchers.MatchResult;
import org.elasticsearch.datageneration.matchers.Messages;
import org.elasticsearch.datageneration.matchers.source.SourceTransforms;
import org.elasticsearch.xcontent.XContentBuilder;

class DynamicFieldMatcher {
    private static final double FLOAT_ERROR_MARGIN = 1.0E-8;
    private final XContentBuilder actualMappings;
    private final Settings.Builder actualSettings;
    private final XContentBuilder expectedMappings;
    private final Settings.Builder expectedSettings;

    DynamicFieldMatcher(XContentBuilder actualMappings, Settings.Builder actualSettings, XContentBuilder expectedMappings, Settings.Builder expectedSettings) {
        this.actualMappings = actualMappings;
        this.actualSettings = actualSettings;
        this.expectedMappings = expectedMappings;
        this.expectedSettings = expectedSettings;
    }

    public MatchResult match(List<Object> actual, List<Object> expected) {
        Boolean isDouble;
        if (expected == null) {
            expected = List.of();
        }
        if (actual == null) {
            actual = List.of();
        }
        if ((isDouble = expected.stream().filter(Objects::nonNull).findFirst().map(o -> o instanceof Double).orElse(false)).booleanValue()) {
            assert (expected.stream().allMatch(o -> o == null || o instanceof Double));
            List<Float> normalizedActual = DynamicFieldMatcher.normalizeDoubles(actual);
            List<Float> normalizedExpected = DynamicFieldMatcher.normalizeDoubles(expected);
            Supplier<MatchResult> noMatchSupplier = () -> MatchResult.noMatch(Messages.formatErrorMessage(this.actualMappings, this.actualSettings, this.expectedMappings, this.expectedSettings, "Values of dynamically mapped field containing double values don't match after normalization, normalized " + Messages.prettyPrintCollections(normalizedActual, normalizedExpected)));
            if (normalizedActual.size() != normalizedExpected.size()) {
                return noMatchSupplier.get();
            }
            for (int i = 0; i < normalizedActual.size(); ++i) {
                if (DynamicFieldMatcher.floatEquals(normalizedActual.get(i), normalizedExpected.get(i))) continue;
                return noMatchSupplier.get();
            }
            return MatchResult.match();
        }
        return this.matchWithGenericMatcher(actual, expected);
    }

    private static List<Float> normalizeDoubles(List<Object> values) {
        if (values == null) {
            return List.of();
        }
        Function<Object, Float> toFloat = o -> {
            Float f;
            if (o instanceof Number) {
                Number n = (Number)o;
                f = Float.valueOf(n.floatValue());
            } else {
                f = Float.valueOf(Float.parseFloat((String)o));
            }
            return f;
        };
        return values.stream().filter(Objects::nonNull).map(toFloat).toList();
    }

    private static boolean floatEquals(Float actual, Float expected) {
        return (double)Math.abs(actual.floatValue() - expected.floatValue()) < 1.0E-8;
    }

    private MatchResult matchWithGenericMatcher(List<Object> actualValues, List<Object> expectedValues) {
        ListEqualMatcher genericListMatcher = new ListEqualMatcher(this.actualMappings, this.actualSettings, this.expectedMappings, this.expectedSettings, SourceTransforms.normalizeValues(actualValues), SourceTransforms.normalizeValues(expectedValues), true);
        return genericListMatcher.match();
    }
}

