/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datageneration.fields.leaf;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.datageneration.FieldDataGenerator;
import org.elasticsearch.datageneration.datasource.DataSource;
import org.elasticsearch.datageneration.datasource.DataSourceRequest;
import org.elasticsearch.datageneration.fields.leaf.Wrappers;

public class BooleanFieldDataGenerator
implements FieldDataGenerator {
    private final DataSource dataSource;
    private final Supplier<Object> booleans;
    private final Supplier<Object> booleansWithStrings;
    private final Supplier<Object> booleansWithStringsAndMalformed;

    public BooleanFieldDataGenerator(DataSource dataSource) {
        this.dataSource = dataSource;
        Supplier<Boolean> booleans = dataSource.get(new DataSourceRequest.BooleanGenerator()).generator();
        this.booleans = booleans::get;
        Function<Supplier<Object>, Supplier<Object>> toStringTransform = dataSource.get(new DataSourceRequest.TransformWrapper(0.5, Object::toString)).wrapper();
        this.booleansWithStrings = toStringTransform.apply(this.booleans::get);
        Supplier<String> strings = dataSource.get(new DataSourceRequest.StringGenerator()).generator();
        this.booleansWithStringsAndMalformed = Wrappers.defaultsWithMalformed(this.booleansWithStrings, strings::get, dataSource);
    }

    @Override
    public Object generateValue(Map<String, Object> fieldMapping) {
        if (fieldMapping == null) {
            return Wrappers.defaults(this.booleans, this.dataSource).get();
        }
        if (((Boolean)fieldMapping.getOrDefault("ignore_malformed", false)).booleanValue()) {
            return this.booleansWithStringsAndMalformed.get();
        }
        return Wrappers.defaults(this.booleansWithStrings, this.dataSource).get();
    }
}

