/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class ShutdownHookManager {
    private static final ShutdownHookManager MGR = new ShutdownHookManager();
    private static final Logger LOG;
    public static final long TIMEOUT_MINIMUM = 1L;
    public static final TimeUnit TIME_UNIT_DEFAULT;
    private static final ExecutorService EXECUTOR;
    private final Set<HookEntry> hooks = Collections.synchronizedSet(new HashSet());
    private AtomicBoolean shutdownInProgress = new AtomicBoolean(false);

    @InterfaceAudience.Private
    @VisibleForTesting
    int executeShutdown() {
        int timeouts = 0;
        for (HookEntry entry : this.getShutdownHooksInOrder()) {
            Future<?> future = EXECUTOR.submit(entry.getHook());
            try {
                future.get(entry.getTimeout(), entry.getTimeUnit());
            }
            catch (TimeoutException ex) {
                ++timeouts;
                future.cancel(true);
                LOG.warn("ShutdownHook '" + entry.getHook().getClass().getSimpleName() + "' timeout, " + ex.toString(), (Throwable)ex);
            }
            catch (Throwable ex) {
                LOG.warn("ShutdownHook '" + entry.getHook().getClass().getSimpleName() + "' failed, " + ex.toString(), ex);
            }
        }
        return timeouts;
    }

    private static void shutdownExecutor(Configuration conf) {
        try {
            EXECUTOR.shutdown();
            long shutdownTimeout = ShutdownHookManager.getShutdownTimeout(conf);
            if (!EXECUTOR.awaitTermination(shutdownTimeout, TIME_UNIT_DEFAULT)) {
                LOG.error("ShutdownHookManager shutdown forcefully after {} seconds.", (Object)shutdownTimeout);
                EXECUTOR.shutdownNow();
            }
            LOG.debug("ShutdownHookManager completed shutdown.");
        }
        catch (InterruptedException ex) {
            LOG.error("ShutdownHookManager interrupted while waiting for termination.", (Throwable)ex);
            EXECUTOR.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    @InterfaceAudience.Public
    public static ShutdownHookManager get() {
        return MGR;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    static long getShutdownTimeout(Configuration conf) {
        long duration = conf.getTimeDuration("hadoop.service.shutdown.timeout", 30L, TIME_UNIT_DEFAULT);
        if (duration < 1L) {
            duration = 1L;
        }
        return duration;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    ShutdownHookManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    @VisibleForTesting
    List<HookEntry> getShutdownHooksInOrder() {
        ArrayList<HookEntry> list;
        Set<HookEntry> set = this.hooks;
        synchronized (set) {
            list = new ArrayList<HookEntry>(this.hooks);
        }
        Collections.sort(list, new Comparator<HookEntry>(){

            @Override
            public int compare(HookEntry o1, HookEntry o2) {
                return o2.priority - o1.priority;
            }
        });
        return list;
    }

    public void addShutdownHook(Runnable runnable, int n) {
    }

    public void addShutdownHook(Runnable runnable, int n, long l, TimeUnit timeUnit) {
    }

    public boolean removeShutdownHook(Runnable runnable) {
        return false;
    }

    public boolean hasShutdownHook(Runnable runnable) {
        return false;
    }

    public boolean isShutdownInProgress() {
        return false;
    }

    public void clearShutdownHooks() {
    }

    static {
        TIME_UNIT_DEFAULT = TimeUnit.SECONDS;
        EXECUTOR = null;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    static class HookEntry {
        private final Runnable hook;
        private final int priority;
        private final long timeout;
        private final TimeUnit unit;

        HookEntry(Runnable hook, int priority) {
            this(hook, priority, ShutdownHookManager.getShutdownTimeout(new Configuration()), TIME_UNIT_DEFAULT);
        }

        HookEntry(Runnable hook, int priority, long timeout, TimeUnit unit) {
            this.hook = hook;
            this.priority = priority;
            this.timeout = timeout;
            this.unit = unit;
        }

        public int hashCode() {
            return this.hook.hashCode();
        }

        public boolean equals(Object obj) {
            boolean eq = false;
            if (obj != null && obj instanceof HookEntry) {
                eq = this.hook == ((HookEntry)obj).hook;
            }
            return eq;
        }

        Runnable getHook() {
            return this.hook;
        }

        int getPriority() {
            return this.priority;
        }

        long getTimeout() {
            return this.timeout;
        }

        TimeUnit getTimeUnit() {
            return this.unit;
        }
    }
}

