/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.serialization;

import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ParseNodeHelper {
    private ParseNodeHelper() {
    }

    @Nonnull
    public static Map<String, Consumer<ParseNode>> mergeDeserializersForIntersectionWrapper(Parsable ... targets) {
        Objects.requireNonNull(targets, "targets cannot be null");
        if (targets.length == 0) {
            throw new IllegalArgumentException("targets cannot be empty");
        }
        Map<String, Consumer<ParseNode>> result = targets[0].getFieldDeserializers();
        for (int i = 1; i < targets.length; ++i) {
            Map<String, Consumer<ParseNode>> targetDeserializers = targets[i].getFieldDeserializers();
            for (Map.Entry<String, Consumer<ParseNode>> entry : targetDeserializers.entrySet()) {
                result.putIfAbsent(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }
}

