/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.serialization;

import com.microsoft.kiota.PeriodAndDuration;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.serialization.ValuedEnum;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FormSerializationWriter
implements SerializationWriter {
    private final ByteArrayOutputStream stream = new ByteArrayOutputStream();
    private final OutputStreamWriter writer;
    private final String encoding = StandardCharsets.UTF_8.name();
    private boolean written;
    private int depth = 0;
    private Consumer<Parsable> onBeforeObjectSerialization;
    private Consumer<Parsable> onAfterObjectSerialization;
    private BiConsumer<Parsable, SerializationWriter> onStartObjectSerialization;

    public FormSerializationWriter() {
        try {
            this.writer = new OutputStreamWriter((OutputStream)this.stream, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("could not create writer", e);
        }
    }

    @Override
    public void writeStringValue(@Nullable String key, @Nullable String value) {
        if (value == null || key == null || key.isEmpty()) {
            return;
        }
        try {
            if (this.written) {
                this.writer.write("&");
            } else {
                this.written = true;
            }
            this.writer.write(URLEncoder.encode(key, this.encoding) + "=" + URLEncoder.encode(value, this.encoding));
        }
        catch (IOException ex) {
            throw new RuntimeException("could not serialize value", ex);
        }
    }

    @Override
    public void writeBooleanValue(@Nullable String key, @Nullable Boolean value) {
        if (value != null) {
            this.writeStringValue(key, value.toString());
        }
    }

    @Override
    public void writeShortValue(@Nullable String key, @Nullable Short value) {
        if (value != null) {
            this.writeStringValue(key, value.toString());
        }
    }

    @Override
    public void writeByteValue(@Nullable String key, @Nullable Byte value) {
        if (value != null) {
            this.writeStringValue(key, value.toString());
        }
    }

    @Override
    public void writeBigDecimalValue(@Nullable String key, @Nullable BigDecimal value) {
        if (value != null) {
            this.writeStringValue(key, value.toString());
        }
    }

    @Override
    public void writeIntegerValue(@Nullable String key, @Nullable Integer value) {
        if (value != null) {
            this.writeStringValue(key, value.toString());
        }
    }

    @Override
    public void writeFloatValue(@Nullable String key, @Nullable Float value) {
        if (value != null) {
            this.writeStringValue(key, value.toString());
        }
    }

    @Override
    public void writeDoubleValue(@Nullable String key, @Nullable Double value) {
        if (value != null) {
            this.writeStringValue(key, value.toString());
        }
    }

    @Override
    public void writeLongValue(@Nullable String key, @Nullable Long value) {
        if (value != null) {
            this.writeStringValue(key, value.toString());
        }
    }

    @Override
    public void writeUUIDValue(@Nullable String key, @Nullable UUID value) {
        if (value != null) {
            this.writeStringValue(key, value.toString());
        }
    }

    @Override
    public void writeOffsetDateTimeValue(@Nullable String key, @Nullable OffsetDateTime value) {
        if (value != null) {
            this.writeStringValue(key, value.format(DateTimeFormatter.ISO_ZONED_DATE_TIME));
        }
    }

    @Override
    public void writeLocalDateValue(@Nullable String key, @Nullable LocalDate value) {
        if (value != null) {
            this.writeStringValue(key, value.format(DateTimeFormatter.ISO_LOCAL_DATE));
        }
    }

    @Override
    public void writeLocalTimeValue(@Nullable String key, @Nullable LocalTime value) {
        if (value != null) {
            this.writeStringValue(key, value.format(DateTimeFormatter.ISO_LOCAL_TIME));
        }
    }

    @Override
    public void writePeriodAndDurationValue(@Nullable String key, @Nullable PeriodAndDuration value) {
        if (value != null) {
            this.writeStringValue(key, value.toString());
        }
    }

    @Override
    public <T> void writeCollectionOfPrimitiveValues(@Nullable String key, @Nullable Iterable<T> values) {
        if (values != null) {
            for (T t : values) {
                this.writeAnyValue(key, t);
            }
        }
    }

    @Override
    public <T extends Parsable> void writeCollectionOfObjectValues(@Nullable String key, @Nullable Iterable<T> values) {
        throw new RuntimeException("collections serialization is not supported with form encoding");
    }

    @Override
    public <T extends Enum<T>> void writeCollectionOfEnumValues(@Nullable String key, @Nullable Iterable<T> values) {
        if (values != null) {
            StringBuffer buffer = new StringBuffer();
            int writtenValuesCount = -1;
            for (Enum t : values) {
                if (++writtenValuesCount > 0) {
                    buffer.append(",");
                }
                buffer.append(this.getStringValueFromValuedEnum(t));
            }
            this.writeStringValue(key, buffer.toString());
        }
    }

    @Override
    public <T extends Parsable> void writeObjectValue(@Nullable String key, @Nullable T value, Parsable ... additionalValuesToMerge) {
        Objects.requireNonNull(additionalValuesToMerge);
        if (this.depth > 0) {
            throw new RuntimeException("serialization of complex properties is not supported with form encoding");
        }
        ++this.depth;
        List nonNullAdditionalValuesToMerge = Stream.of(additionalValuesToMerge).filter(Objects::nonNull).collect(Collectors.toList());
        if (value != null || nonNullAdditionalValuesToMerge.size() > 0) {
            if (this.onBeforeObjectSerialization != null && value != null) {
                this.onBeforeObjectSerialization.accept(value);
            }
            if (value != null) {
                if (this.onStartObjectSerialization != null) {
                    this.onStartObjectSerialization.accept(value, this);
                }
                value.serialize(this);
            }
            for (Parsable additionalValueToMerge : nonNullAdditionalValuesToMerge) {
                if (this.onBeforeObjectSerialization != null) {
                    this.onBeforeObjectSerialization.accept(additionalValueToMerge);
                }
                if (this.onStartObjectSerialization != null) {
                    this.onStartObjectSerialization.accept(additionalValueToMerge, this);
                }
                additionalValueToMerge.serialize(this);
                if (this.onAfterObjectSerialization == null) continue;
                this.onAfterObjectSerialization.accept(additionalValueToMerge);
            }
            if (this.onAfterObjectSerialization != null && value != null) {
                this.onAfterObjectSerialization.accept(value);
            }
        }
    }

    @Override
    public <T extends Enum<T>> void writeEnumSetValue(@Nullable String key, @Nullable EnumSet<T> values) {
        Optional<String> concatenatedValue;
        if (values != null && !values.isEmpty() && (concatenatedValue = values.stream().map(v -> this.getStringValueFromValuedEnum(v)).reduce((x, y) -> x + "," + y)).isPresent()) {
            this.writeStringValue(key, concatenatedValue.get());
        }
    }

    @Override
    public <T extends Enum<T>> void writeEnumValue(@Nullable String key, @Nullable T value) {
        if (value != null) {
            this.writeStringValue(key, this.getStringValueFromValuedEnum(value));
        }
    }

    @Override
    public void writeNullValue(@Nullable String key) {
        this.writeStringValue(key, "null");
    }

    private <T extends Enum<T>> String getStringValueFromValuedEnum(T value) {
        if (value instanceof ValuedEnum) {
            ValuedEnum valued = (ValuedEnum)((Object)value);
            return valued.getValue();
        }
        return null;
    }

    @Override
    @Nonnull
    public InputStream getSerializedContent() {
        try {
            this.writer.flush();
            return new ByteArrayInputStream(this.stream.toByteArray());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
        this.stream.close();
    }

    @Override
    public void writeAdditionalData(@Nonnull Map<String, Object> value) {
        if (value == null) {
            return;
        }
        for (Map.Entry<String, Object> dataValue : value.entrySet()) {
            this.writeAnyValue(dataValue.getKey(), dataValue.getValue());
        }
    }

    private void writeAnyValue(@Nullable String key, @Nullable Object value) {
        if (value == null) {
            this.writeNullValue(key);
        } else {
            Class<?> valueClass = value.getClass();
            if (valueClass.equals(String.class)) {
                this.writeStringValue(key, (String)value);
            } else if (valueClass.equals(Boolean.class)) {
                this.writeBooleanValue(key, (Boolean)value);
            } else if (valueClass.equals(Byte.class)) {
                this.writeByteValue(key, (Byte)value);
            } else if (valueClass.equals(Short.class)) {
                this.writeShortValue(key, (Short)value);
            } else if (valueClass.equals(BigDecimal.class)) {
                this.writeBigDecimalValue(key, (BigDecimal)value);
            } else if (valueClass.equals(Float.class)) {
                this.writeFloatValue(key, (Float)value);
            } else if (valueClass.equals(Long.class)) {
                this.writeLongValue(key, (Long)value);
            } else if (valueClass.equals(Integer.class)) {
                this.writeIntegerValue(key, (Integer)value);
            } else if (valueClass.equals(UUID.class)) {
                this.writeUUIDValue(key, (UUID)value);
            } else if (valueClass.equals(OffsetDateTime.class)) {
                this.writeOffsetDateTimeValue(key, (OffsetDateTime)value);
            } else if (valueClass.equals(LocalDate.class)) {
                this.writeLocalDateValue(key, (LocalDate)value);
            } else if (valueClass.equals(LocalTime.class)) {
                this.writeLocalTimeValue(key, (LocalTime)value);
            } else if (valueClass.equals(PeriodAndDuration.class)) {
                this.writePeriodAndDurationValue(key, (PeriodAndDuration)value);
            } else if (value instanceof Iterable) {
                this.writeCollectionOfPrimitiveValues(key, (Iterable)value);
            } else {
                throw new RuntimeException("unknown type to serialize " + valueClass.getName());
            }
        }
    }

    @Override
    @Nullable
    public Consumer<Parsable> getOnBeforeObjectSerialization() {
        return this.onBeforeObjectSerialization;
    }

    @Override
    @Nullable
    public Consumer<Parsable> getOnAfterObjectSerialization() {
        return this.onAfterObjectSerialization;
    }

    @Override
    @Nullable
    public BiConsumer<Parsable, SerializationWriter> getOnStartObjectSerialization() {
        return this.onStartObjectSerialization;
    }

    @Override
    public void setOnBeforeObjectSerialization(@Nullable Consumer<Parsable> value) {
        this.onBeforeObjectSerialization = value;
    }

    @Override
    public void setOnAfterObjectSerialization(@Nullable Consumer<Parsable> value) {
        this.onAfterObjectSerialization = value;
    }

    @Override
    public void setOnStartObjectSerialization(@Nullable BiConsumer<Parsable, SerializationWriter> value) {
        this.onStartObjectSerialization = value;
    }

    @Override
    public void writeByteArrayValue(@Nullable String key, @Nullable @Nonnull byte[] value) {
        if (value != null) {
            this.writeStringValue(key, Base64.getEncoder().encodeToString(value));
        }
    }
}

