/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest.commonshttp;

import java.io.IOException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.Socket;
import java.net.UnknownHostException;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.ConnectTimeoutException;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.params.HttpConnectionParams;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.protocol.DefaultProtocolSocketFactory;
import org.elasticsearch.hadoop.util.StringUtils;

class SocksSocketFactory
extends DefaultProtocolSocketFactory {
    private final String socksHost;
    private final int socksPort;

    SocksSocketFactory(String socksHost, int socksPort) {
        this(socksHost, socksPort, null, null);
    }

    SocksSocketFactory(String socksHost, int socksPort, String user, String pass) {
        this.socksHost = socksHost;
        this.socksPort = socksPort;
        if (StringUtils.hasText(user)) {
            final PasswordAuthentication auth = new PasswordAuthentication(user, pass.toCharArray());
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return auth;
                }
            });
        }
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        InetSocketAddress socksAddr = new InetSocketAddress(this.socksHost, this.socksPort);
        Proxy proxy = new Proxy(Proxy.Type.SOCKS, socksAddr);
        int timeout = params.getConnectionTimeout();
        Socket socket = new Socket(proxy);
        socket.setSoTimeout(timeout);
        InetSocketAddress localaddr = new InetSocketAddress(localAddress, localPort);
        InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
        socket.bind(localaddr);
        socket.connect(remoteaddr, timeout);
        return socket;
    }

    @Override
    public int hashCode() {
        return SocksSocketFactory.class.hashCode();
    }
}

