/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.hive;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.StringUtils;

public class HiveBytesArrayWritable
extends BinaryComparable
implements WritableComparable<BinaryComparable>,
Serializable {
    private transient BytesArray ba = null;

    public int getLength() {
        return this.ba != null ? this.ba.length() : 0;
    }

    public byte[] getBytes() {
        return this.ba != null ? this.ba.bytes() : BytesArray.EMPTY;
    }

    public void setContent(BytesArray ba) {
        this.ba = ba;
    }

    public BytesArray getContent() {
        return this.ba;
    }

    public void readFields(DataInput in) throws IOException {
        int size = in.readInt();
        byte[] bytes = new byte[size];
        in.readFully(bytes, 0, size);
        this.ba = new BytesArray(bytes);
    }

    public void write(DataOutput out) throws IOException {
        int size = this.ba != null ? this.ba.length() : 0;
        byte[] bytes = this.ba != null ? this.ba.bytes() : BytesArray.EMPTY;
        out.writeInt(size);
        out.write(bytes, 0, size);
    }

    public boolean equals(Object right_obj) {
        if (right_obj instanceof HiveBytesArrayWritable) {
            return super.equals(right_obj);
        }
        return false;
    }

    public int hashCode() {
        return WritableComparator.hashBytes((byte[])this.ba.bytes(), (int)this.ba.length());
    }

    public String toString() {
        return this.ba != null ? StringUtils.asUTFString(this.ba.bytes(), 0, this.ba.length()) : "";
    }

    static {
        WritableComparator.define(HiveBytesArrayWritable.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator
    implements Serializable {
        public Comparator() {
            super(HiveBytesArrayWritable.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            return Comparator.compareBytes((byte[])b1, (int)(s1 + 4), (int)(l1 - 4), (byte[])b2, (int)(s2 + 4), (int)(l2 - 4));
        }
    }
}

