/**
 * MIT License
 *
 * Copyright (c) 2020-present, Elastic NV
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 */
import { PushOptions } from '../common_types';
import { Monitor } from '../dsl/monitor';
export declare function logDiff<T extends Set<string>>(newIDs: T, changedIDs: T, removedIDs: T, unchangedIDs: T): void;
export declare function logGroups<T extends Set<string>>(sizes: Map<string, number>, newIDs: T, changedIDs: T, removedIDs: T, unchangedIDs: T): void;
export declare function printBytes(bytes: number): string;
export declare function getBatches(arr: string[], size: number): string[][];
export declare function getSizedBatches<T extends {
    id?: string;
}>(arr: Array<T>, sizes: Map<string, number>, maxBatchSizeKB: number, maxBatchItems: number): Array<T[]>;
type Operation = 'status' | 'bulk_get' | 'bulk_update' | 'bulk_delete' | 'legacy' | 'location';
export declare function generateURL(options: PushOptions, operation: Operation): string;
/**
 * Bulk API is supported for push monitors only from 8.6.0 and above
 */
export declare function isBulkAPISupported(version: string): boolean;
/**
 * Lightweight monitors are supported only from 8.5.0 and above
 */
export declare function isLightweightMonitorSupported(monitors: Monitor[], options: PushOptions): boolean;
/**
 * Lighweight monitor param options are supported only from
 * 8.7.2 and above
 */
export declare function isParamOptionSupported(version: string): boolean;
/**
 * Helper that replaces url paths traversal issues when bundling
 */
export declare function normalizeMonitorName(p: string, replacement?: string): string;
export {};
//# sourceMappingURL=utils.d.ts.map