/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ackedqueue;

import co.elastic.logstash.api.UserMetric;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.ackedqueue.IORatioMetric;
import org.logstash.instrument.metrics.AbstractMetric;

class AtomicIORatioMetric
extends AbstractMetric<Double>
implements IORatioMetric {
    public static UserMetric.Factory<IORatioMetric> FACTORY = IORatioMetric.PROVIDER.getFactory(AtomicIORatioMetric::new);
    private static final MathContext LIMITED_PRECISION = new MathContext(4, RoundingMode.HALF_UP);
    private static final ImmutableRatio ZERO = new ImmutableRatio(0L, 0L);
    private static final Logger LOGGER = LogManager.getLogger(AtomicIORatioMetric.class);
    private final AtomicReference<ImmutableRatio> atomicReference = new AtomicReference<ImmutableRatio>(ZERO);
    private final Logger logger;

    AtomicIORatioMetric(String name) {
        this(name, LOGGER);
    }

    AtomicIORatioMetric(String name, Logger logger) {
        super(name);
        this.logger = logger;
    }

    @Override
    public IORatioMetric.Value getLifetime() {
        return this.atomicReference.get();
    }

    @Override
    public void incrementBy(int bytesIn, int bytesOut) {
        if (bytesIn < 0 || bytesOut < 0) {
            this.logger.warn("cannot decrement IORatioMetric {}", (Object)this.getName());
            return;
        }
        this.atomicReference.getAndUpdate(existing -> this.doIncrement((ImmutableRatio)existing, bytesIn, bytesOut));
    }

    void setTo(long bytesIn, long bytesOut) {
        this.atomicReference.set(new ImmutableRatio(bytesIn, bytesOut));
    }

    @Override
    public Double getValue() {
        IORatioMetric.Value snapshot = this.getLifetime();
        BigDecimal bytesIn = BigDecimal.valueOf(snapshot.bytesIn());
        BigDecimal bytesOut = BigDecimal.valueOf(snapshot.bytesOut());
        if (bytesIn.signum() == 0) {
            return switch (bytesOut.signum()) {
                case -1 -> Double.NEGATIVE_INFINITY;
                case 1 -> Double.POSITIVE_INFINITY;
                default -> Double.NaN;
            };
        }
        return bytesOut.divide(bytesIn, LIMITED_PRECISION).doubleValue();
    }

    public void reset() {
        this.atomicReference.set(ZERO);
    }

    private ImmutableRatio doIncrement(ImmutableRatio existing, int bytesIn, int bytesOut) {
        long combinedBytesIn = existing.bytesIn() + (long)bytesIn;
        long combinedBytesOut = existing.bytesOut() + (long)bytesOut;
        if (combinedBytesIn < 0L || combinedBytesOut < 0L) {
            this.logger.warn("long overflow; precision will be reduced");
            long reducedBytesIn = Math.addExact(Math.floorDiv(existing.bytesIn(), 2), (long)bytesIn);
            long reducedBytesOut = Math.addExact(Math.floorDiv(existing.bytesOut(), 2), (long)bytesOut);
            return new ImmutableRatio(reducedBytesIn, reducedBytesOut);
        }
        return new ImmutableRatio(combinedBytesIn, combinedBytesOut);
    }

    public record ImmutableRatio(long bytesIn, long bytesOut) implements IORatioMetric.Value
    {
    }
}

