/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.datafeed;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.DateHistogramValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public final class DatafeedConfigUtils {
    private DatafeedConfigUtils() {
    }

    public static long getHistogramIntervalMillis(AggregatorFactories.Builder aggFactory) {
        AggregationBuilder histogram = DatafeedConfigUtils.getHistogramAggregation(aggFactory.getAggregatorFactories());
        return DatafeedConfigUtils.getHistogramIntervalMillis(histogram);
    }

    public static AggregationBuilder getHistogramAggregation(Collection<AggregationBuilder> aggregations) {
        if (aggregations.isEmpty()) {
            throw ExceptionsHelper.badRequestException(Messages.getMessage("A date_histogram (or histogram) aggregation is required"), new Object[0]);
        }
        if (aggregations.size() != 1) {
            throw ExceptionsHelper.badRequestException("The date_histogram (or histogram) aggregation cannot have sibling aggregations", new Object[0]);
        }
        AggregationBuilder agg = aggregations.iterator().next();
        if (DatafeedConfigUtils.isHistogram(agg)) {
            return agg;
        }
        return DatafeedConfigUtils.getHistogramAggregation(agg.getSubAggregations());
    }

    public static boolean isHistogram(AggregationBuilder aggregationBuilder) {
        return aggregationBuilder instanceof HistogramAggregationBuilder || aggregationBuilder instanceof DateHistogramAggregationBuilder || DatafeedConfigUtils.isCompositeWithDateHistogramSource(aggregationBuilder);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isCompositeWithDateHistogramSource(AggregationBuilder aggregationBuilder) {
        if (!(aggregationBuilder instanceof CompositeAggregationBuilder)) return false;
        if (!((CompositeAggregationBuilder)aggregationBuilder).sources().stream().anyMatch(DateHistogramValuesSourceBuilder.class::isInstance)) return false;
        return true;
    }

    public static DateHistogramValuesSourceBuilder getDateHistogramValuesSource(CompositeAggregationBuilder compositeAggregationBuilder) {
        for (CompositeValuesSourceBuilder<?> valuesSourceBuilder : compositeAggregationBuilder.sources()) {
            if (!(valuesSourceBuilder instanceof DateHistogramValuesSourceBuilder)) continue;
            DateHistogramValuesSourceBuilder dateHistogramValuesSourceBuilder = (DateHistogramValuesSourceBuilder)valuesSourceBuilder;
            return dateHistogramValuesSourceBuilder;
        }
        throw ExceptionsHelper.badRequestException("[composite] aggregations require exactly one [date_histogram] value source", new Object[0]);
    }

    public static long getHistogramIntervalMillis(AggregationBuilder histogramAggregation) {
        if (histogramAggregation instanceof HistogramAggregationBuilder) {
            HistogramAggregationBuilder histo = (HistogramAggregationBuilder)histogramAggregation;
            return (long)histo.interval();
        }
        if (histogramAggregation instanceof DateHistogramAggregationBuilder) {
            DateHistogramAggregationBuilder dateHisto = (DateHistogramAggregationBuilder)histogramAggregation;
            return DatafeedConfigUtils.validateAndGetDateHistogramInterval(DateHistogramAggOrValueSource.fromAgg(dateHisto));
        }
        if (histogramAggregation instanceof CompositeAggregationBuilder) {
            CompositeAggregationBuilder composite = (CompositeAggregationBuilder)histogramAggregation;
            return DatafeedConfigUtils.validateAndGetDateHistogramInterval(DateHistogramAggOrValueSource.fromCompositeAgg(composite));
        }
        throw new IllegalStateException("Invalid histogram aggregation [" + histogramAggregation.getName() + "]");
    }

    private static long validateAndGetDateHistogramInterval(DateHistogramAggOrValueSource dateHistogram) {
        if (dateHistogram.timeZone() != null && !dateHistogram.timeZone().normalized().equals(ZoneOffset.UTC)) {
            throw ExceptionsHelper.badRequestException("ML requires date_histogram.time_zone to be UTC", new Object[0]);
        }
        if (dateHistogram.getCalendarInterval() != null) {
            return DatafeedConfigUtils.validateAndGetCalendarInterval(dateHistogram.getCalendarInterval().toString());
        }
        if (dateHistogram.getFixedInterval() != null) {
            return dateHistogram.getFixedInterval().estimateMillis();
        }
        throw new IllegalArgumentException("Must specify an interval for date_histogram");
    }

    public static long validateAndGetCalendarInterval(String calendarInterval) {
        TimeValue interval;
        Rounding.DateTimeUnit dateTimeUnit = DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(calendarInterval);
        if (dateTimeUnit != null) {
            interval = switch (dateTimeUnit) {
                default -> throw new MatchException(null, null);
                case Rounding.DateTimeUnit.WEEK_OF_WEEKYEAR -> new TimeValue(7L, TimeUnit.DAYS);
                case Rounding.DateTimeUnit.DAY_OF_MONTH -> new TimeValue(1L, TimeUnit.DAYS);
                case Rounding.DateTimeUnit.HOUR_OF_DAY -> new TimeValue(1L, TimeUnit.HOURS);
                case Rounding.DateTimeUnit.MINUTE_OF_HOUR -> new TimeValue(1L, TimeUnit.MINUTES);
                case Rounding.DateTimeUnit.SECOND_OF_MINUTE -> new TimeValue(1L, TimeUnit.SECONDS);
                case Rounding.DateTimeUnit.MONTH_OF_YEAR, Rounding.DateTimeUnit.YEAR_OF_CENTURY, Rounding.DateTimeUnit.QUARTER_OF_YEAR, Rounding.DateTimeUnit.YEARS_OF_CENTURY, Rounding.DateTimeUnit.MONTHS_OF_YEAR -> throw ExceptionsHelper.badRequestException(DatafeedConfigUtils.invalidDateHistogramCalendarIntervalMessage(calendarInterval), new Object[0]);
            };
        } else {
            interval = TimeValue.parseTimeValue(calendarInterval, "date_histogram.calendar_interval");
        }
        if (interval.days() > 7L) {
            throw ExceptionsHelper.badRequestException(DatafeedConfigUtils.invalidDateHistogramCalendarIntervalMessage(calendarInterval), new Object[0]);
        }
        return interval.millis();
    }

    private static String invalidDateHistogramCalendarIntervalMessage(String interval) {
        throw ExceptionsHelper.badRequestException("When specifying a date_histogram calendar interval [" + interval + "], ML does not accept intervals longer than a week because of variable lengths of periods greater than a week", new Object[0]);
    }

    private static class DateHistogramAggOrValueSource {
        private final DateHistogramAggregationBuilder agg;
        private final DateHistogramValuesSourceBuilder sourceBuilder;

        static DateHistogramAggOrValueSource fromAgg(DateHistogramAggregationBuilder agg) {
            return new DateHistogramAggOrValueSource(agg, null);
        }

        static DateHistogramAggOrValueSource fromCompositeAgg(CompositeAggregationBuilder compositeAggregationBuilder) {
            return new DateHistogramAggOrValueSource(null, DatafeedConfigUtils.getDateHistogramValuesSource(compositeAggregationBuilder));
        }

        private DateHistogramAggOrValueSource(DateHistogramAggregationBuilder agg, DateHistogramValuesSourceBuilder sourceBuilder) {
            assert (agg != null || sourceBuilder != null);
            this.agg = agg;
            this.sourceBuilder = sourceBuilder;
        }

        private ZoneId timeZone() {
            return this.agg != null ? this.agg.timeZone() : this.sourceBuilder.timeZone();
        }

        private DateHistogramInterval getFixedInterval() {
            return this.agg != null ? this.agg.getFixedInterval() : this.sourceBuilder.getIntervalAsFixed();
        }

        private DateHistogramInterval getCalendarInterval() {
            return this.agg != null ? this.agg.getCalendarInterval() : this.sourceBuilder.getIntervalAsCalendar();
        }
    }
}

