/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.StartDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class StopDataFrameAnalyticsAction
extends ActionType<Response> {
    public static final StopDataFrameAnalyticsAction INSTANCE = new StopDataFrameAnalyticsAction();
    public static final String NAME = "cluster:admin/xpack/ml/data_frame/analytics/stop";
    public static final TimeValue DEFAULT_TIMEOUT = new TimeValue(30L, TimeUnit.SECONDS);

    private StopDataFrameAnalyticsAction() {
        super(NAME);
    }

    public static class Response
    extends BaseTasksResponse
    implements Writeable,
    ToXContentObject {
        private final boolean stopped;

        public Response(boolean stopped) {
            super(null, null);
            this.stopped = stopped;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.stopped = in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.stopped);
        }

        public boolean isStopped() {
            return this.stopped;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.toXContentCommon(builder, params);
            builder.field("stopped", this.stopped);
            builder.endObject();
            return builder;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return this.stopped == response.stopped;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.stopped);
        }
    }

    public static final class Request
    extends BaseTasksRequest<Request>
    implements ToXContentObject {
        public static final ParseField ALLOW_NO_MATCH = new ParseField("allow_no_match", new String[0]);
        public static final ParseField FORCE = new ParseField("force", new String[0]);
        public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
        private static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:admin/xpack/ml/data_frame/analytics/stop", Request::new);
        private String id;
        private boolean allowNoMatch = true;
        private boolean force;
        private Set<String> expandedIds = Collections.emptySet();

        public static Request parseRequest(String id, XContentParser parser) {
            Request request = PARSER.apply(parser, null);
            if (request.getId() == null) {
                request.setId(id);
            } else if (!Strings.isNullOrEmpty(id) && !id.equals(request.getId())) {
                throw new IllegalArgumentException(Messages.getMessage("Inconsistent {0}; ''{1}'' specified in the body differs from ''{2}'' specified as a URL argument", DataFrameAnalyticsConfig.ID, request.getId(), id));
            }
            return request;
        }

        public Request(String id) {
            this();
            this.setId(id);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.id = in.readString();
            this.allowNoMatch = in.readBoolean();
            this.force = in.readBoolean();
            this.expandedIds = new HashSet<String>(Arrays.asList(in.readStringArray()));
        }

        public Request() {
            this.setTimeout(DEFAULT_TIMEOUT);
        }

        public Request setId(String id) {
            this.id = ExceptionsHelper.requireNonNull(id, DataFrameAnalyticsConfig.ID);
            return this;
        }

        public String getId() {
            return this.id;
        }

        public boolean allowNoMatch() {
            return this.allowNoMatch;
        }

        public Request setAllowNoMatch(boolean allowNoMatch) {
            this.allowNoMatch = allowNoMatch;
            return this;
        }

        public boolean isForce() {
            return this.force;
        }

        public Request setForce(boolean force) {
            this.force = force;
            return this;
        }

        @Nullable
        public Set<String> getExpandedIds() {
            return this.expandedIds;
        }

        public void setExpandedIds(Set<String> expandedIds) {
            this.expandedIds = Objects.requireNonNull(expandedIds);
        }

        @Override
        public boolean match(Task task) {
            return this.expandedIds.stream().anyMatch(expandedId -> StartDataFrameAnalyticsAction.TaskMatcher.match(task, expandedId));
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.id);
            out.writeBoolean(this.allowNoMatch);
            out.writeBoolean(this.force);
            out.writeStringCollection(this.expandedIds);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field(DataFrameAnalyticsConfig.ID.getPreferredName(), this.id).field(ALLOW_NO_MATCH.getPreferredName(), this.allowNoMatch).field(FORCE.getPreferredName(), this.force).endObject();
        }

        public int hashCode() {
            return Objects.hash(this.id, this.getTimeout(), this.allowNoMatch, this.force, this.expandedIds);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.getTimeout(), other.getTimeout()) && this.allowNoMatch == other.allowNoMatch && this.force == other.force && Objects.equals(this.expandedIds, other.expandedIds);
        }

        @Override
        public String toString() {
            return Strings.toString(this);
        }

        static {
            PARSER.declareString((request, id) -> {
                request.id = id;
            }, DataFrameAnalyticsConfig.ID);
            PARSER.declareString((request, val) -> request.setTimeout(TimeValue.parseTimeValue(val, TIMEOUT.getPreferredName())), TIMEOUT);
            PARSER.declareBoolean(Request::setAllowNoMatch, ALLOW_NO_MATCH);
            PARSER.declareBoolean(Request::setForce, FORCE);
        }
    }
}

