/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class SetUpgradeModeActionRequest
extends AcknowledgedRequest<SetUpgradeModeActionRequest>
implements ToXContentObject {
    private final boolean enabled;
    private static final ParseField ENABLED = new ParseField("enabled", new String[0]);
    public static final ConstructingObjectParser<SetUpgradeModeActionRequest, Void> PARSER = new ConstructingObjectParser("set_upgrade_mode_action_request", a -> new SetUpgradeModeActionRequest((Boolean)a[0]));

    public SetUpgradeModeActionRequest(boolean enabled) {
        super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT, DEFAULT_ACK_TIMEOUT);
        this.enabled = enabled;
    }

    public SetUpgradeModeActionRequest(StreamInput in) throws IOException {
        super(in);
        this.enabled = in.readBoolean();
    }

    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.enabled);
    }

    public int hashCode() {
        return Objects.hash(this.enabled);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SetUpgradeModeActionRequest other = (SetUpgradeModeActionRequest)obj;
        return this.enabled == other.enabled();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ENABLED.getPreferredName(), this.enabled);
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), ENABLED);
    }
}

