/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.HnswQueueSaturationCollector;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.knn.KnnCollectorManager;
import org.apache.lucene.search.knn.KnnSearchStrategy;

class PatienceCollectorManager
implements KnnCollectorManager {
    private static final double DEFAULT_SATURATION_THRESHOLD = 0.995;
    private final KnnCollectorManager knnCollectorManager;
    private final int patience;
    private final double saturationThreshold;

    PatienceCollectorManager(KnnCollectorManager knnCollectorManager, int patience, double saturationThreshold) {
        this.knnCollectorManager = knnCollectorManager;
        this.patience = patience;
        this.saturationThreshold = saturationThreshold;
    }

    static KnnCollectorManager wrap(KnnCollectorManager knnCollectorManager, int k) {
        return new PatienceCollectorManager(knnCollectorManager, Math.max(7, (int)((double)k * 0.3)), 0.995);
    }

    @Override
    public KnnCollector newCollector(int visitLimit, KnnSearchStrategy searchStrategy, LeafReaderContext ctx) throws IOException {
        return new HnswQueueSaturationCollector(this.knnCollectorManager.newCollector(visitLimit, searchStrategy, ctx), this.saturationThreshold, this.patience);
    }

    @Override
    public KnnCollector newOptimisticCollector(int visitLimit, KnnSearchStrategy searchStrategy, LeafReaderContext ctx, int k) throws IOException {
        if (this.knnCollectorManager.isOptimistic()) {
            return new HnswQueueSaturationCollector(this.knnCollectorManager.newOptimisticCollector(visitLimit, searchStrategy, ctx, k), this.saturationThreshold, this.patience);
        }
        return null;
    }

    @Override
    public boolean isOptimistic() {
        return this.knnCollectorManager.isOptimistic();
    }
}

