/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.dfs;

import java.io.IOException;
import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.Lucene;

public class DfsKnnResults
implements Writeable {
    private final String nestedPath;
    private final ScoreDoc[] scoreDocs;

    public DfsKnnResults(String nestedPath, ScoreDoc[] scoreDocs) {
        this.nestedPath = nestedPath;
        this.scoreDocs = scoreDocs;
    }

    public DfsKnnResults(StreamInput in) throws IOException {
        this.scoreDocs = in.readArray(Lucene::readScoreDoc, ScoreDoc[]::new);
        this.nestedPath = in.getTransportVersion().onOrAfter(TransportVersions.V_8_11_X) ? in.readOptionalString() : null;
    }

    public String getNestedPath() {
        return this.nestedPath;
    }

    public ScoreDoc[] scoreDocs() {
        return this.scoreDocs;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeArray(Lucene::writeScoreDoc, this.scoreDocs);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_11_X)) {
            out.writeOptionalString(this.nestedPath);
        }
    }
}

