/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms.heuristic;

import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.xcontent.ToXContentFragment;

public abstract class SignificanceHeuristic
implements NamedWriteable,
ToXContentFragment {
    public abstract double getScore(long var1, long var3, long var5, long var7);

    protected static void checkFrequencyValidity(long subsetFreq, long subsetSize, long supersetFreq, long supersetSize, String scoreFunctionName) {
        if (subsetFreq < 0L || subsetSize < 0L || supersetFreq < 0L || supersetSize < 0L) {
            throw new IllegalArgumentException("Frequencies of subset and superset must be positive in " + scoreFunctionName + ".getScore()");
        }
        if (subsetFreq > subsetSize) {
            throw new IllegalArgumentException("subsetFreq > subsetSize, in " + scoreFunctionName);
        }
        if (supersetFreq > supersetSize) {
            throw new IllegalArgumentException("supersetFreq > supersetSize, in " + scoreFunctionName);
        }
    }

    public SignificanceHeuristic rewrite(AggregationReduceContext reduceContext) {
        return this;
    }

    public SignificanceHeuristic rewrite(AggregationContext context) {
        return this;
    }
}

