/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.api;

import java.io.IOException;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.json.JsonXContent;

public class Json {
    public static Object load(String json) throws IOException {
        try (XContentParser parser = JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY, json);){
            Object object = switch (parser.nextToken()) {
                case XContentParser.Token.START_ARRAY -> parser.list();
                case XContentParser.Token.START_OBJECT -> parser.map();
                case XContentParser.Token.VALUE_NUMBER -> parser.numberValue();
                case XContentParser.Token.VALUE_BOOLEAN -> parser.booleanValue();
                case XContentParser.Token.VALUE_STRING -> parser.text();
                default -> null;
            };
            return object;
        }
    }

    public static String dump(Object data) throws IOException {
        return Json.dump(data, false);
    }

    public static String dump(Object data, boolean pretty) throws IOException {
        XContentBuilder builder = JsonXContent.contentBuilder();
        if (pretty) {
            builder.prettyPrint();
        }
        builder.value(data);
        builder.flush();
        return builder.getOutputStream().toString();
    }
}

