/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.license.License;
import org.elasticsearch.license.PostStartTrialAction;
import org.elasticsearch.license.PostStartTrialRequest;
import org.elasticsearch.license.PostStartTrialResponse;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.XContentBuilder;

public class RestPostStartTrialLicense
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_license/start_trial"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        final PostStartTrialRequest startTrialRequest = new PostStartTrialRequest(RestUtils.getMasterNodeTimeout(request));
        startTrialRequest.setType(request.param("type", License.LicenseType.TRIAL.getTypeName()));
        startTrialRequest.acknowledge(request.paramAsBoolean("acknowledge", false));
        return channel -> client.execute(PostStartTrialAction.INSTANCE, startTrialRequest, new RestBuilderListener<PostStartTrialResponse>(this, channel){

            @Override
            public RestResponse buildResponse(PostStartTrialResponse response, XContentBuilder builder) throws Exception {
                PostStartTrialResponse.Status status = response.getStatus();
                builder.startObject();
                builder.field("acknowledged", startTrialRequest.isAcknowledged());
                if (status.isTrialStarted()) {
                    builder.field("trial_was_started", true);
                    builder.field("type", startTrialRequest.getType());
                } else {
                    builder.field("trial_was_started", false);
                    builder.field("error_message", status.getErrorMessage());
                }
                Map<String, String[]> acknowledgementMessages = response.getAcknowledgementMessages();
                if (!acknowledgementMessages.isEmpty()) {
                    builder.startObject("acknowledge");
                    builder.field("message", response.getAcknowledgementMessage());
                    for (Map.Entry<String, String[]> entry : acknowledgementMessages.entrySet()) {
                        builder.array(entry.getKey(), entry.getValue());
                    }
                    builder.endObject();
                }
                builder.endObject();
                return new RestResponse(status.getRestStatus(), builder);
            }
        });
    }

    @Override
    public String getName() {
        return "post_start_trial";
    }
}

