/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.bitset;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BitSet;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.cache.CacheLoader;
import org.elasticsearch.common.cache.RemovalListener;
import org.elasticsearch.common.cache.RemovalNotification;
import org.elasticsearch.common.lucene.index.ElasticsearchDirectoryReader;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexWarmer;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.NestedLookup;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardUtils;
import org.elasticsearch.lucene.util.BitSets;
import org.elasticsearch.threadpool.ThreadPool;

public final class BitsetFilterCache
implements IndexReader.ClosedListener,
RemovalListener<IndexReader.CacheKey, Cache<Query, Value>>,
Closeable {
    public static final Setting<Boolean> INDEX_LOAD_RANDOM_ACCESS_FILTERS_EAGERLY_SETTING = Setting.boolSetting("index.load_fixed_bitset_filters_eagerly", true, Setting.Property.IndexScope);
    private static final Logger logger = LogManager.getLogger(BitsetFilterCache.class);
    private final boolean loadRandomAccessFiltersEagerly;
    private volatile Cache<IndexReader.CacheKey, Cache<Query, Value>> loadedFilters;
    private final Listener listener;
    private final Index index;

    public BitsetFilterCache(IndexSettings indexSettings, Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.index = indexSettings.getIndex();
        this.loadRandomAccessFiltersEagerly = BitsetFilterCache.shouldLoadRandomAccessFiltersEagerly(indexSettings);
        this.listener = listener;
    }

    static boolean shouldLoadRandomAccessFiltersEagerly(IndexSettings settings) {
        boolean loadFiltersEagerlySetting = settings.getValue(INDEX_LOAD_RANDOM_ACCESS_FILTERS_EAGERLY_SETTING);
        boolean isStateless = DiscoveryNode.isStateless(settings.getNodeSettings());
        if (isStateless) {
            return loadFiltersEagerlySetting && DiscoveryNode.hasRole(settings.getNodeSettings(), DiscoveryNodeRole.SEARCH_ROLE);
        }
        return loadFiltersEagerlySetting;
    }

    public static BitSet bitsetFromQuery(Query query, LeafReaderContext context) throws IOException {
        IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext(context);
        IndexSearcher searcher = new IndexSearcher(topLevelContext);
        searcher.setQueryCache(null);
        Weight weight = searcher.createWeight(searcher.rewrite(query), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        Scorer s = weight.scorer(context);
        if (s == null) {
            return null;
        }
        return BitSets.of(s.iterator(), context.reader().maxDoc());
    }

    public IndexWarmer.Listener createListener(ThreadPool threadPool) {
        return new BitSetProducerWarmer(threadPool);
    }

    public BitSetProducer getBitSetProducer(Query query) {
        return new QueryWrapperBitSetProducer(query);
    }

    @Override
    public void onClose(IndexReader.CacheKey ownerCoreCacheKey) {
        Cache<IndexReader.CacheKey, Cache<Query, Value>> filters = this.loadedFilters;
        if (filters != null) {
            filters.invalidate(ownerCoreCacheKey);
        }
    }

    @Override
    public void close() {
        this.clear("close");
    }

    public void clear(String reason) {
        logger.debug("clearing all bitsets for [{}] because [{}]", (Object)this.index, (Object)reason);
        Cache<IndexReader.CacheKey, Cache<Query, Value>> filters = this.loadedFilters;
        if (filters != null) {
            filters.invalidateAll();
        }
    }

    private BitSet getAndLoadIfNotPresent(Query query, LeafReaderContext context) throws ExecutionException {
        IndexReader.CacheHelper cacheHelper = context.reader().getCoreCacheHelper();
        if (cacheHelper == null) {
            throw new IllegalArgumentException("Reader " + String.valueOf(context.reader()) + " does not support caching");
        }
        IndexReader.CacheKey coreCacheReader = cacheHelper.getKey();
        ShardId shardId = ShardUtils.extractShardId(context.reader());
        if (shardId == null) {
            throw new IllegalStateException("Null shardId. If you got here from a test, you need to wrap the directory reader. see for example AggregatorTestCase#wrapInMockESDirectoryReader.  If you got here in production, please file a bug.");
        }
        if (!this.index.equals(shardId.getIndex())) {
            throw new IllegalStateException("Trying to load bit set for index " + String.valueOf(shardId.getIndex()) + " with cache of index " + String.valueOf(this.index));
        }
        Cache<IndexReader.CacheKey, Cache<Query, Value>> filters = this.loadedFilters;
        if (filters == null) {
            filters = this.buildFiltersCache();
        }
        Cache filterToFbs = filters.computeIfAbsent(coreCacheReader, key -> {
            cacheHelper.addClosedListener(this);
            return CacheBuilder.builder().build();
        });
        return filterToFbs.computeIfAbsent(query, (CacheLoader<Query, Value>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getAndLoadIfNotPresent$1(org.apache.lucene.search.Query org.apache.lucene.index.LeafReaderContext org.elasticsearch.index.shard.ShardId org.apache.lucene.search.Query ), (Lorg/apache/lucene/search/Query;)Lorg/elasticsearch/index/cache/bitset/BitsetFilterCache$Value;)((BitsetFilterCache)this, (Query)query, (LeafReaderContext)context, (ShardId)shardId)).bitset;
    }

    private synchronized Cache<IndexReader.CacheKey, Cache<Query, Value>> buildFiltersCache() {
        Cache<IndexReader.CacheKey, Cache<Query, Value>> existing = this.loadedFilters;
        if (existing != null) {
            return existing;
        }
        this.loadedFilters = existing = CacheBuilder.builder().removalListener(this).build();
        return existing;
    }

    @Override
    public void onRemoval(RemovalNotification<IndexReader.CacheKey, Cache<Query, Value>> notification) {
        if (notification.getKey() == null) {
            return;
        }
        Cache<Query, Value> valueCache = notification.getValue();
        if (valueCache == null) {
            return;
        }
        for (Value value : valueCache.values()) {
            this.listener.onRemoval(value.shardId, value.bitset);
        }
    }

    Cache<IndexReader.CacheKey, Cache<Query, Value>> getLoadedFilters() {
        return this.loadedFilters;
    }

    private /* synthetic */ Value lambda$getAndLoadIfNotPresent$1(Query query, LeafReaderContext context, ShardId shardId, Query key) throws Exception {
        BitSet bitSet = BitsetFilterCache.bitsetFromQuery(query, context);
        Value value = new Value(bitSet, shardId);
        this.listener.onCache(shardId, value.bitset);
        return value;
    }

    public static interface Listener {
        public static final Listener NOOP = new Listener(){

            @Override
            public void onCache(ShardId shardId, Accountable accountable) {
            }

            @Override
            public void onRemoval(ShardId shardId, Accountable accountable) {
            }
        };

        public void onCache(ShardId var1, Accountable var2);

        public void onRemoval(ShardId var1, Accountable var2);
    }

    final class BitSetProducerWarmer
    implements IndexWarmer.Listener {
        private final Executor executor;

        BitSetProducerWarmer(ThreadPool threadPool) {
            this.executor = threadPool.executor("warmer");
        }

        @Override
        public IndexWarmer.TerminationHandle warmReader(IndexShard indexShard, ElasticsearchDirectoryReader reader) {
            if (!BitsetFilterCache.this.index.equals(indexShard.indexSettings().getIndex())) {
                return IndexWarmer.TerminationHandle.NO_WAIT;
            }
            if (!BitsetFilterCache.this.loadRandomAccessFiltersEagerly) {
                return IndexWarmer.TerminationHandle.NO_WAIT;
            }
            HashSet<Query> warmUp = new HashSet<Query>();
            MapperService mapperService = indexShard.mapperService();
            MappingLookup lookup = mapperService.mappingLookup();
            NestedLookup nestedLookup = lookup.nestedLookup();
            if (nestedLookup != NestedLookup.EMPTY) {
                warmUp.add(Queries.newNonNestedFilter(mapperService.getIndexSettings().getIndexVersionCreated()));
                warmUp.addAll(nestedLookup.getNestedParentFilters().values());
            }
            CountDownLatch latch = new CountDownLatch(reader.leaves().size() * warmUp.size());
            for (LeafReaderContext ctx : reader.leaves()) {
                for (Query filterToWarm : warmUp) {
                    this.executor.execute(() -> {
                        try {
                            long start = System.nanoTime();
                            BitsetFilterCache.this.getAndLoadIfNotPresent(filterToWarm, ctx);
                            if (indexShard.warmerService().logger().isTraceEnabled()) {
                                indexShard.warmerService().logger().trace("warmed bitset for [{}], took [{}]", (Object)filterToWarm, (Object)TimeValue.timeValueNanos(System.nanoTime() - start));
                            }
                        }
                        catch (Exception e) {
                            indexShard.warmerService().logger().warn(() -> "failed to load bitset for [" + String.valueOf(filterToWarm) + "]", (Throwable)e);
                        }
                        finally {
                            latch.countDown();
                        }
                    });
                }
            }
            return () -> latch.await();
        }
    }

    final class QueryWrapperBitSetProducer
    implements BitSetProducer {
        final Query query;

        QueryWrapperBitSetProducer(Query query) {
            this.query = Objects.requireNonNull(query);
        }

        public BitSet getBitSet(LeafReaderContext context) {
            try {
                return BitsetFilterCache.this.getAndLoadIfNotPresent(this.query, context);
            }
            catch (ExecutionException e) {
                throw FutureUtils.rethrowExecutionException(e);
            }
        }

        public String toString() {
            return "random_access(" + String.valueOf(this.query) + ")";
        }

        public boolean equals(Object o) {
            if (!(o instanceof QueryWrapperBitSetProducer)) {
                return false;
            }
            return this.query.equals(((QueryWrapperBitSetProducer)o).query);
        }

        public int hashCode() {
            return 31 * this.getClass().hashCode() + this.query.hashCode();
        }
    }

    public static final class Value {
        final BitSet bitset;
        final ShardId shardId;

        public Value(BitSet bitset, ShardId shardId) {
            this.bitset = bitset;
            this.shardId = shardId;
        }
    }
}

