/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;

public final class MinScoreScorer
extends Scorer {
    private final Scorer in;
    private final float minScore;
    private float curScore;
    private final float boost;

    public MinScoreScorer(Scorer scorer, float minScore) {
        this(scorer, minScore, 1.0f);
    }

    public MinScoreScorer(Scorer scorer, float minScore, float boost) {
        this.in = scorer;
        this.minScore = minScore;
        this.boost = boost;
    }

    @Override
    public int docID() {
        return this.in.docID();
    }

    @Override
    public float score() {
        return this.curScore * this.boost;
    }

    @Override
    public int advanceShallow(int target) throws IOException {
        return this.in.advanceShallow(target);
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        return this.in.getMaxScore(upTo);
    }

    @Override
    public DocIdSetIterator iterator() {
        return TwoPhaseIterator.asDocIdSetIterator(this.twoPhaseIterator());
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        DocIdSetIterator approximation;
        TwoPhaseIterator inTwoPhase = this.in.twoPhaseIterator();
        if (inTwoPhase == null) {
            approximation = this.in.iterator();
            if (TwoPhaseIterator.unwrap(approximation) != null) {
                inTwoPhase = TwoPhaseIterator.unwrap(approximation);
                approximation = inTwoPhase.approximation();
            }
        } else {
            approximation = inTwoPhase.approximation();
        }
        final TwoPhaseIterator finalTwoPhase = inTwoPhase;
        return new TwoPhaseIterator(approximation){

            @Override
            public boolean matches() throws IOException {
                if (finalTwoPhase != null && !finalTwoPhase.matches()) {
                    return false;
                }
                MinScoreScorer.this.curScore = MinScoreScorer.this.in.score();
                return MinScoreScorer.this.curScore >= MinScoreScorer.this.minScore;
            }

            @Override
            public float matchCost() {
                return 1000.0f + (finalTwoPhase == null ? 0.0f : finalTwoPhase.matchCost());
            }
        };
    }
}

