/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.service;

import java.io.IOException;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.Text;

public record PendingClusterTask(long insertOrder, Priority priority, Text source, long timeInQueue, boolean executing) implements Writeable
{
    public PendingClusterTask(StreamInput in) throws IOException {
        this(in.readVLong(), Priority.readFrom(in), in.readText(), in.readLong(), in.readBoolean());
    }

    public PendingClusterTask {
        assert (timeInQueue >= 0L) : "got a negative timeInQueue [" + timeInQueue + "]";
        assert (insertOrder >= 0L) : "got a negative insertOrder [" + insertOrder + "]";
    }

    public long getInsertOrder() {
        return this.insertOrder;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public Text getSource() {
        return this.source;
    }

    public long getTimeInQueueInMillis() {
        return this.timeInQueue;
    }

    public TimeValue getTimeInQueue() {
        return new TimeValue(this.getTimeInQueueInMillis());
    }

    public boolean isExecuting() {
        return this.executing;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.insertOrder);
        Priority.writeTo(this.priority, out);
        out.writeText(this.source);
        out.writeLong(this.timeInQueue);
        out.writeBoolean(this.executing);
    }
}

