/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.index.Index;

public class GlobalRoutingTable
implements Iterable<RoutingTable>,
Diffable<GlobalRoutingTable> {
    public static final GlobalRoutingTable EMPTY_ROUTING_TABLE = new GlobalRoutingTable(ImmutableOpenMap.of());
    private final ImmutableOpenMap<ProjectId, RoutingTable> routingTables;

    public GlobalRoutingTable(ImmutableOpenMap<ProjectId, RoutingTable> routingTables) {
        this.routingTables = routingTables;
    }

    public GlobalRoutingTable rebuild(RoutingNodes routingNodes, Metadata metadata) {
        Map<ProjectId, List<ShardRouting>> byProject = Maps.transformValues(this.routingTables, ignore -> new ArrayList());
        for (RoutingNode routingNode : routingNodes) {
            String nodeContext = "Node [" + String.valueOf(routingNode) + "]";
            for (ShardRouting shardRoutingEntry : routingNode) {
                if (shardRoutingEntry.initializing() && shardRoutingEntry.relocatingNodeId() != null) continue;
                GlobalRoutingTable.collectProjectEntry(shardRoutingEntry, byProject, metadata, nodeContext);
            }
        }
        for (ShardRouting shardRoutingEntry : routingNodes.unassigned()) {
            GlobalRoutingTable.collectProjectEntry(shardRoutingEntry, byProject, metadata, "unassigned-shards");
        }
        for (ShardRouting shardRoutingEntry : routingNodes.unassigned().ignored()) {
            GlobalRoutingTable.collectProjectEntry(shardRoutingEntry, byProject, metadata, "ignored-shards");
        }
        Builder builder = GlobalRoutingTable.builder(this);
        for (Map.Entry<ProjectId, List<ShardRouting>> entry : byProject.entrySet()) {
            ProjectId project = entry.getKey();
            RoutingTable oldTable = this.routingTables.get(project);
            RoutingTable rebuiltTable = RoutingTable.of((Collection<ShardRouting>)entry.getValue());
            if (oldTable.indicesRouting().equals(rebuiltTable.indicesRouting())) continue;
            builder.put(project, rebuiltTable);
        }
        return builder.build();
    }

    private static void collectProjectEntry(ShardRouting shardRouting, Map<ProjectId, List<ShardRouting>> projectRoutingLists, Metadata metadata, String context) {
        ProjectMetadata project = metadata.lookupProject(shardRouting.index()).orElseThrow(() -> new IllegalStateException("Found shard [" + String.valueOf(shardRouting.shardId()) + "] in " + context + ", but the index does not belong to any project"));
        List<ShardRouting> routingSet = projectRoutingLists.get(project.id());
        if (routingSet == null) {
            throw new IllegalStateException("Shard [" + String.valueOf(shardRouting.shardId()) + "] is part of project [" + String.valueOf(project) + "] but the global routing table does not have an entry for that project-id");
        }
        routingSet.add(shardRouting);
    }

    @Deprecated
    public RoutingTable getRoutingTable() {
        return switch (this.routingTables.size()) {
            case 0 -> RoutingTable.EMPTY_ROUTING_TABLE;
            case 1 -> this.routingTables.values().iterator().next();
            default -> throw new Metadata.MultiProjectPendingException("There are multiple project routing tables [" + String.valueOf(this.routingTables.keySet()) + "]");
        };
    }

    public RoutingTable routingTable(ProjectId projectId) {
        return this.routingTables.computeIfAbsent(projectId, ignore -> {
            throw new IllegalStateException("No routing table for project [" + String.valueOf(projectId) + "]");
        });
    }

    public ImmutableOpenMap<ProjectId, RoutingTable> routingTables() {
        return this.routingTables;
    }

    public int size() {
        return this.routingTables.size();
    }

    @Override
    public Iterator<RoutingTable> iterator() {
        return this.routingTables.values().iterator();
    }

    @Override
    public Diff<GlobalRoutingTable> diff(GlobalRoutingTable previousState) {
        return new GlobalRoutingTableDiff(previousState, this);
    }

    public static Diff<GlobalRoutingTable> readDiffFrom(StreamInput in) throws IOException {
        return new GlobalRoutingTableDiff(in);
    }

    public static GlobalRoutingTable readFrom(StreamInput in) throws IOException {
        ImmutableOpenMap<ProjectId, RoutingTable> table = in.readImmutableOpenMap(ProjectId::readFrom, RoutingTable::readFrom);
        return new GlobalRoutingTable(table);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.routingTables);
    }

    public boolean hasSameIndexRouting(GlobalRoutingTable other) {
        if (this.routingTables.size() != other.routingTables.size()) {
            return false;
        }
        for (Map.Entry<ProjectId, RoutingTable> entry : this.routingTables.entrySet()) {
            ProjectId projectId = entry.getKey();
            RoutingTable thisTable = entry.getValue();
            RoutingTable thatTable = other.routingTables.get(projectId);
            if (thatTable == null) {
                return false;
            }
            if (thisTable.indicesRouting() == thatTable.indicesRouting()) continue;
            return false;
        }
        return true;
    }

    int totalIndexCount() {
        int sum = 0;
        for (RoutingTable table : this) {
            sum += table.indicesRouting().size();
        }
        return sum;
    }

    public GlobalRoutingTable removeProject(ProjectId project) {
        if (!this.routingTables.containsKey(project)) {
            return this;
        }
        ImmutableOpenMap.Builder<ProjectId, RoutingTable> builder = ImmutableOpenMap.builder(this.routingTables.size() - 1);
        for (Map.Entry<ProjectId, RoutingTable> entry : this.routingTables.entrySet()) {
            if (entry.getKey().equals(project)) continue;
            builder.put(entry.getKey(), entry.getValue());
        }
        return new GlobalRoutingTable(builder.build());
    }

    public GlobalRoutingTable initializeProjects(Set<ProjectId> projectIds) {
        if (this.routingTables.keySet().containsAll(projectIds)) {
            return this;
        }
        Map<ProjectId, RoutingTable> newTable = Maps.newMapWithExpectedSize(this.size() + projectIds.size());
        newTable.putAll(this.routingTables);
        projectIds.forEach(id -> newTable.computeIfAbsent((ProjectId)id, ignore -> RoutingTable.EMPTY_ROUTING_TABLE));
        return new GlobalRoutingTable(ImmutableOpenMap.builder(newTable).build());
    }

    public boolean validate(Metadata metadata) {
        Map<ProjectId, ProjectMetadata> metadataProjects = metadata.projects();
        if (metadataProjects.size() != this.routingTables.size()) {
            throw new IllegalStateException("routing table has [" + this.routingTables.size() + "] projects [" + String.valueOf(this.routingTables.keySet()) + "] but metadata has [" + metadataProjects.size() + "] [" + String.valueOf(metadataProjects.keySet()) + "]");
        }
        for (Map.Entry<ProjectId, RoutingTable> entry : this.routingTables.entrySet()) {
            ProjectId projectId = entry.getKey();
            ProjectMetadata projectMetadata = metadataProjects.get(projectId);
            if (projectMetadata == null) {
                throw new IllegalStateException("Routing table has an entry for project [" + String.valueOf(projectId) + "] but metadata does not");
            }
            if (entry.getValue().validate(projectMetadata)) continue;
            throw new IllegalStateException("Routing table for project [" + String.valueOf(projectId) + "] is not valid");
        }
        return true;
    }

    public Iterable<IndexRoutingTable> indexRouting() {
        return Iterables.flatten(this);
    }

    public Optional<IndexRoutingTable> indexRouting(Metadata metadata, Index index) {
        return metadata.lookupProject(index).flatMap(pm -> this.indexRouting(pm.id(), index));
    }

    public Optional<IndexRoutingTable> indexRouting(ProjectId id, Index index) {
        return Optional.ofNullable(this.routingTable(id)).map(rt -> rt.index(index));
    }

    public boolean hasIndices() {
        return this.routingTables().values().stream().anyMatch(rt -> !rt.indicesRouting().isEmpty());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GlobalRoutingTable routingTable) {
        return new Builder(routingTable);
    }

    public String toString() {
        return "global_routing_table{" + String.valueOf(this.routingTables) + "}";
    }

    public static class Builder {
        private final ImmutableOpenMap.Builder<ProjectId, RoutingTable> projectRouting;

        public Builder(GlobalRoutingTable init) {
            this.projectRouting = ImmutableOpenMap.builder(init.routingTables);
        }

        public Builder() {
            this.projectRouting = ImmutableOpenMap.builder();
        }

        public Builder put(ProjectId id, RoutingTable routing) {
            this.projectRouting.put(id, routing);
            return this;
        }

        public Builder put(ProjectId id, RoutingTable.Builder routing) {
            return this.put(id, routing.build());
        }

        public Builder removeProject(ProjectId projectId) {
            this.projectRouting.remove(projectId);
            return this;
        }

        public Builder clear() {
            this.projectRouting.clear();
            return this;
        }

        public GlobalRoutingTable build() {
            return new GlobalRoutingTable(this.projectRouting.build());
        }
    }

    private static class GlobalRoutingTableDiff
    implements Diff<GlobalRoutingTable> {
        private static final DiffableUtils.KeySerializer<ProjectId> PROJECT_ID_KEY_SERIALIZER = DiffableUtils.getWriteableKeySerializer(ProjectId.READER);
        private static final DiffableUtils.DiffableValueReader<ProjectId, RoutingTable> DIFF_VALUE_READER = new DiffableUtils.DiffableValueReader(RoutingTable::readFrom, RoutingTable::readDiffFrom);
        private final Diff<ImmutableOpenMap<ProjectId, RoutingTable>> routingTable;
        private final Diff<RoutingTable> singleProjectForBwc;

        GlobalRoutingTableDiff(GlobalRoutingTable before, GlobalRoutingTable after) {
            this.routingTable = DiffableUtils.diff(before.routingTables, after.routingTables, PROJECT_ID_KEY_SERIALIZER);
            if (before.size() == 1 && after.size() == 1) {
                RoutingTable afterTable = after.routingTables.values().iterator().next();
                RoutingTable beforeTable = before.routingTables.values().iterator().next();
                this.singleProjectForBwc = afterTable.diff(beforeTable);
            } else {
                this.singleProjectForBwc = null;
            }
        }

        GlobalRoutingTableDiff(StreamInput in) throws IOException {
            if (in.getTransportVersion().onOrAfter(TransportVersions.MULTI_PROJECT)) {
                this.routingTable = DiffableUtils.readImmutableOpenMapDiff(in, PROJECT_ID_KEY_SERIALIZER, DIFF_VALUE_READER);
                this.singleProjectForBwc = null;
            } else {
                this.routingTable = null;
                this.singleProjectForBwc = RoutingTable.readDiffFrom(in);
            }
        }

        @Override
        public GlobalRoutingTable apply(GlobalRoutingTable part) {
            if (this.routingTable == null && this.singleProjectForBwc != null) {
                if (part.size() != 1) {
                    throw new IllegalStateException("Attempt to apply BWC (single project) diff to a table with [" + part.size() + "] projects");
                }
                Map.Entry<ProjectId, RoutingTable> entry = part.routingTables.entrySet().iterator().next();
                RoutingTable updatedTable = this.singleProjectForBwc.apply(entry.getValue());
                return new GlobalRoutingTable(ImmutableOpenMap.builder(Map.of(entry.getKey(), updatedTable)).build());
            }
            ImmutableOpenMap<ProjectId, RoutingTable> updatedTable = this.routingTable.apply(part.routingTables);
            if (updatedTable == part.routingTables) {
                return part;
            }
            return new GlobalRoutingTable(updatedTable);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion().onOrAfter(TransportVersions.MULTI_PROJECT)) {
                this.routingTable.writeTo(out);
            } else if (this.singleProjectForBwc != null) {
                this.singleProjectForBwc.writeTo(out);
            } else {
                throw new IllegalStateException("Cannot write a multi-project diff to a stream with version [" + String.valueOf(out.getTransportVersion()) + "]");
            }
        }
    }
}

