/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.block;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataIndexStateService;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.rest.RestStatus;

public class ClusterBlocks
implements Diffable<ClusterBlocks> {
    private static final ClusterBlock[] EMPTY_BLOCKS_ARRAY = new ClusterBlock[0];
    public static final ClusterBlocks EMPTY_CLUSTER_BLOCK = new ClusterBlocks(Set.of(), Map.of());
    private static final TransportVersion PROJECT_DELETION_GLOBAL_BLOCK = TransportVersion.fromName("project_deletion_global_block");
    private final Set<ClusterBlock> global;
    final Map<ProjectId, ProjectBlocks> projectBlocksMap;
    private final EnumMap<ClusterBlockLevel, ImmutableLevelHolder> levelHolders;

    ClusterBlocks(Set<ClusterBlock> global, Map<ProjectId, ProjectBlocks> projectBlocksMap) {
        this.global = global;
        assert (projectBlocksMap.values().stream().allMatch(projectBlocks -> !projectBlocks.isEmpty())) : "Map must not contain projects with empty blocks " + String.valueOf(projectBlocksMap);
        this.projectBlocksMap = projectBlocksMap;
        this.levelHolders = ClusterBlocks.generateLevelHolders(global, projectBlocksMap);
    }

    public Set<ClusterBlock> global() {
        return this.global;
    }

    public Set<ClusterBlock> global(ProjectId projectId) {
        return Sets.union(this.global, this.projectBlocks(projectId).projectGlobals());
    }

    public boolean noProjectHasAProjectBlock() {
        return this.projectBlocksMap.values().stream().allMatch(ProjectBlocks::isEmpty);
    }

    public Map<String, Set<ClusterBlock>> indices(ProjectId projectId) {
        return this.projectBlocks(projectId).indices();
    }

    public ProjectBlocks projectBlocks(ProjectId projectId) {
        return this.projectBlocksMap.getOrDefault(projectId, ProjectBlocks.EMPTY);
    }

    protected Set<ClusterBlock> projectGlobal(ProjectId projectId) {
        return this.projectBlocks(projectId).projectGlobals();
    }

    public Set<ClusterBlock> global(ClusterBlockLevel level) {
        return this.levelHolders.get((Object)level).global();
    }

    public Set<ClusterBlock> global(ProjectId projectId, ClusterBlockLevel level) {
        ImmutableLevelHolder levelHolder = this.levelHolders.get((Object)level);
        return Sets.union(levelHolder.global, levelHolder.projects.getOrDefault(projectId, ProjectBlocks.EMPTY).projectGlobals());
    }

    public Map<String, Set<ClusterBlock>> indices(ProjectId projectId, ClusterBlockLevel level) {
        return this.levelHolders.get((Object)((Object)level)).projects.getOrDefault(projectId, ProjectBlocks.EMPTY).indices();
    }

    private Set<ClusterBlock> blocksForIndex(ProjectId projectId, ClusterBlockLevel level, String index) {
        return this.indices(projectId, level).getOrDefault(index, Set.of());
    }

    private static EnumMap<ClusterBlockLevel, ImmutableLevelHolder> generateLevelHolders(Set<ClusterBlock> global, Map<ProjectId, ProjectBlocks> projectBlocksMap) {
        EnumMap<ClusterBlockLevel, ImmutableLevelHolder> levelHolders = new EnumMap<ClusterBlockLevel, ImmutableLevelHolder>(ClusterBlockLevel.class);
        ArrayList<ClusterBlock> scratch = new ArrayList<ClusterBlock>();
        Map<ProjectId, ProjectBlocks> projectsBuilder = Maps.newMapWithExpectedSize(projectBlocksMap.size());
        Map<String, Set<ClusterBlock>> indicesBuilder = Maps.newMapWithExpectedSize(projectBlocksMap.values().stream().mapToInt(pb -> pb.indices().size()).max().orElse(0));
        for (ClusterBlockLevel level : ClusterBlockLevel.values()) {
            for (Map.Entry<ProjectId, ProjectBlocks> projectEntry : projectBlocksMap.entrySet()) {
                for (Map.Entry<String, Set<ClusterBlock>> indexEntry : projectEntry.getValue().indices().entrySet()) {
                    indicesBuilder.put(indexEntry.getKey(), ClusterBlocks.addBlocksAtLevel(indexEntry.getValue(), scratch, level));
                }
                Set<ClusterBlock> projectGlobals = ClusterBlocks.addBlocksAtLevel(projectEntry.getValue().projectGlobals(), scratch, level);
                projectsBuilder.put(projectEntry.getKey(), new ProjectBlocks(Map.copyOf(indicesBuilder), projectGlobals));
                indicesBuilder.clear();
            }
            levelHolders.put(level, new ImmutableLevelHolder(ClusterBlocks.addBlocksAtLevel(global, scratch, level), Map.copyOf(projectsBuilder)));
            projectsBuilder.clear();
        }
        return levelHolders;
    }

    private static Set<ClusterBlock> addBlocksAtLevel(Set<ClusterBlock> blocks, List<ClusterBlock> scratch, ClusterBlockLevel level) {
        for (ClusterBlock clusterBlock : blocks) {
            if (!clusterBlock.contains(level)) continue;
            scratch.add(clusterBlock);
        }
        Set<ClusterBlock> res = Set.of(scratch.toArray(EMPTY_BLOCKS_ARRAY));
        scratch.clear();
        return res;
    }

    public boolean disableStatePersistence() {
        for (ClusterBlock clusterBlock : this.global) {
            if (!clusterBlock.disableStatePersistence()) continue;
            return true;
        }
        return false;
    }

    public boolean hasGlobalBlock(ClusterBlock block) {
        return this.global.contains(block);
    }

    public boolean hasGlobalBlock(ProjectId projectId, ClusterBlock block) {
        return this.global(projectId).contains(block);
    }

    public boolean hasGlobalBlockWithId(int blockId) {
        for (ClusterBlock clusterBlock : this.global) {
            if (clusterBlock.id() != blockId) continue;
            return true;
        }
        return false;
    }

    public boolean hasGlobalBlockWithLevel(ClusterBlockLevel level) {
        return this.global(level).size() > 0;
    }

    public boolean hasGlobalBlockWithLevel(ProjectId projectId, ClusterBlockLevel level) {
        return this.global(projectId, level).size() > 0;
    }

    public boolean hasGlobalBlockWithStatus(RestStatus status) {
        for (ClusterBlock clusterBlock : this.global) {
            if (!clusterBlock.status().equals((Object)status)) continue;
            return true;
        }
        return false;
    }

    @Deprecated(forRemoval=true)
    public boolean hasIndexBlock(String index, ClusterBlock block) {
        this.throwIfMultiProjects();
        return this.hasIndexBlock(Metadata.DEFAULT_PROJECT_ID, index, block);
    }

    public boolean hasIndexBlock(ProjectId projectId, String index, ClusterBlock block) {
        ProjectBlocks projectBlocks = this.projectBlocksMap.get(projectId);
        if (projectBlocks == null) {
            return false;
        }
        Set<ClusterBlock> clusterBlocks = projectBlocks.get(index);
        if (clusterBlocks == null) {
            return false;
        }
        return clusterBlocks.contains(block);
    }

    public boolean hasIndexBlockLevel(ProjectId projectId, String index, ClusterBlockLevel level) {
        return !this.blocksForIndex(projectId, level, index).isEmpty();
    }

    public boolean hasIndexBlockWithId(ProjectId projectId, String index, int blockId) {
        return this.getIndexBlockWithId(projectId, index, blockId) != null;
    }

    @Nullable
    public ClusterBlock getIndexBlockWithId(ProjectId projectId, String index, int blockId) {
        Set<ClusterBlock> clusterBlocks;
        ProjectBlocks projectBlocks = this.projectBlocksMap.get(projectId);
        if (projectBlocks != null && (clusterBlocks = projectBlocks.get(index)) != null) {
            for (ClusterBlock clusterBlock : clusterBlocks) {
                if (clusterBlock.id() != blockId) continue;
                return clusterBlock;
            }
        }
        return null;
    }

    public void globalBlockedRaiseException(ClusterBlockLevel level) throws ClusterBlockException {
        ClusterBlockException blockException = this.globalBlockedException(level);
        if (blockException != null) {
            throw blockException;
        }
    }

    public void globalBlockedRaiseException(ProjectId projectId, ClusterBlockLevel level) throws ClusterBlockException {
        ClusterBlockException blockException = this.globalBlockedException(projectId, level);
        if (blockException != null) {
            throw blockException;
        }
    }

    private boolean globalBlocked(ClusterBlockLevel level) {
        return !this.global(level).isEmpty();
    }

    private boolean globalBlocked(ProjectId projectId, ClusterBlockLevel level) {
        return !this.global(projectId, level).isEmpty();
    }

    public ClusterBlockException globalBlockedException(ClusterBlockLevel level) {
        if (!this.globalBlocked(level)) {
            return null;
        }
        return new ClusterBlockException(this.global(level));
    }

    public ClusterBlockException globalBlockedException(ProjectId projectId, ClusterBlockLevel level) {
        if (!this.globalBlocked(projectId, level)) {
            return null;
        }
        return new ClusterBlockException(this.global(projectId, level));
    }

    public void indexBlockedRaiseException(ProjectId projectId, ClusterBlockLevel level, String index) throws ClusterBlockException {
        ClusterBlockException blockException = this.indexBlockedException(projectId, level, index);
        if (blockException != null) {
            throw blockException;
        }
    }

    @Deprecated(forRemoval=true)
    public ClusterBlockException indexBlockedException(ClusterBlockLevel level, String index) {
        return this.indexBlockedException(Metadata.DEFAULT_PROJECT_ID, level, index);
    }

    public ClusterBlockException indexBlockedException(ProjectId projectId, ClusterBlockLevel level, String index) {
        return this.indicesBlockedException(projectId, level, new String[]{index});
    }

    @Deprecated(forRemoval=true)
    public boolean indexBlocked(ClusterBlockLevel level, String index) {
        return this.indexBlocked(Metadata.DEFAULT_PROJECT_ID, level, index);
    }

    public boolean indexBlocked(ProjectId projectId, ClusterBlockLevel level, String index) {
        return this.globalBlocked(projectId, level) || !this.blocksForIndex(projectId, level, index).isEmpty();
    }

    @Deprecated(forRemoval=true)
    public ClusterBlockException indicesBlockedException(ClusterBlockLevel level, String[] indices) {
        return this.indicesBlockedException(Metadata.DEFAULT_PROJECT_ID, level, indices);
    }

    public ClusterBlockException indicesBlockedException(ProjectId projectId, ClusterBlockLevel level, String[] indices) {
        Set<ClusterBlock> globalLevelBlocks = this.global(projectId, level);
        HashMap<String, Set<ClusterBlock>> indexLevelBlocks = new HashMap<String, Set<ClusterBlock>>();
        for (String index : indices) {
            Set<ClusterBlock> indexBlocks = this.blocksForIndex(projectId, level, index);
            if (indexBlocks.isEmpty() && globalLevelBlocks.isEmpty()) continue;
            indexLevelBlocks.put(index, Sets.union(indexBlocks, globalLevelBlocks));
        }
        if (indexLevelBlocks.isEmpty()) {
            if (!globalLevelBlocks.isEmpty()) {
                return new ClusterBlockException(globalLevelBlocks);
            }
            return null;
        }
        return new ClusterBlockException(indexLevelBlocks);
    }

    public ClusterBlockException indicesAllowReleaseResources(ProjectId projectId, String[] indices) {
        Set<ClusterBlock> globalBlocks = this.global(projectId, ClusterBlockLevel.METADATA_WRITE).stream().filter(clusterBlock -> !clusterBlock.isAllowReleaseResources()).collect(Collectors.toSet());
        HashMap<String, Set<ClusterBlock>> indexLevelBlocks = new HashMap<String, Set<ClusterBlock>>();
        for (String index : indices) {
            Set blocks = Sets.union(globalBlocks, this.blocksForIndex(projectId, ClusterBlockLevel.METADATA_WRITE, index)).stream().filter(clusterBlock -> !clusterBlock.isAllowReleaseResources()).collect(Collectors.toSet());
            if (blocks.isEmpty()) continue;
            indexLevelBlocks.put(index, Sets.union(globalBlocks, blocks));
        }
        if (indexLevelBlocks.isEmpty()) {
            if (!globalBlocks.isEmpty()) {
                return new ClusterBlockException(globalBlocks);
            }
            return null;
        }
        return new ClusterBlockException(indexLevelBlocks);
    }

    public String toString() {
        if (this.global.isEmpty() && this.noProjectHasAProjectBlock()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("blocks: \n");
        if (!this.global.isEmpty()) {
            sb.append("   _global_:\n");
            for (ClusterBlock block : this.global) {
                sb.append("      ").append(block).append("\n");
            }
        }
        for (ProjectId projectId : this.projectBlocksMap.keySet().stream().sorted(Comparator.comparing(ProjectId::id)).toList()) {
            Map<String, Set<ClusterBlock>> indices = this.indices(projectId);
            sb.append("   ").append(projectId).append(":\n");
            if (!this.projectGlobal(projectId).isEmpty()) {
                sb.append("      _project_global_:\n");
            }
            for (ClusterBlock clusterBlock : this.projectGlobal(projectId)) {
                sb.append("         ").append(clusterBlock).append("\n");
            }
            for (Map.Entry entry : indices.entrySet()) {
                sb.append("      ").append((String)entry.getKey()).append(":\n");
                for (ClusterBlock block : (Set)entry.getValue()) {
                    sb.append("         ").append(block).append("\n");
                }
            }
        }
        return sb.toString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().onOrAfter(TransportVersions.MULTI_PROJECT)) {
            ClusterBlocks.writeBlockSet(this.global, out);
            out.writeMap(this.projectBlocksMap, (o, projectId) -> projectId.writeTo(o), (o, projectBlocks) -> projectBlocks.writeTo(out));
        } else if (this.noProjectOrDefaultProjectOnly()) {
            this.writeToSingleProjectNode(out);
        } else {
            throw new IllegalStateException("Cannot write multi-project blocks to a stream with version [" + String.valueOf(out.getTransportVersion()) + "]");
        }
    }

    private void writeToSingleProjectNode(StreamOutput out) throws IOException {
        ClusterBlocks.writeBlockSet(this.global, out);
        out.writeMap(this.indices(Metadata.DEFAULT_PROJECT_ID), (o, s) -> ClusterBlocks.writeBlockSet(s, o));
    }

    @Override
    public Diff<ClusterBlocks> diff(ClusterBlocks previousState) {
        if (this.equals(previousState)) {
            return SimpleDiffable.empty();
        }
        return new ClusterBlocksDiff(this, false);
    }

    private boolean noProjectOrDefaultProjectOnly() {
        return ClusterBlocks.noProjectOrDefaultProjectOnly(this.projectBlocksMap);
    }

    private static boolean noProjectOrDefaultProjectOnly(Map<ProjectId, ?> projectBlocksMap) {
        return projectBlocksMap.isEmpty() || projectBlocksMap.size() == 1 && projectBlocksMap.containsKey(Metadata.DEFAULT_PROJECT_ID);
    }

    private void throwIfMultiProjects() {
        if (!this.noProjectOrDefaultProjectOnly()) {
            throw new Metadata.MultiProjectPendingException("expect no project or only the default-project, but got " + String.valueOf(this.projectBlocksMap.keySet()));
        }
    }

    private static void writeBlockSet(Set<ClusterBlock> blocks, StreamOutput out) throws IOException {
        out.writeCollection(blocks);
    }

    public static ClusterBlocks readFrom(StreamInput in) throws IOException {
        if (in.getTransportVersion().onOrAfter(TransportVersions.MULTI_PROJECT)) {
            Set<ClusterBlock> global = ClusterBlocks.readBlockSet(in);
            Map<ProjectId, ProjectBlocks> projectBlocksMap = in.readImmutableMap(ProjectId::readFrom, ProjectBlocks::readFrom);
            if (global.isEmpty() && ClusterBlocks.noProjectOrDefaultProjectOnly(projectBlocksMap) && projectBlocksMap.getOrDefault(Metadata.DEFAULT_PROJECT_ID, ProjectBlocks.EMPTY).indices().isEmpty()) {
                return EMPTY_CLUSTER_BLOCK;
            }
            return new ClusterBlocks(global, projectBlocksMap);
        }
        return ClusterBlocks.readFromSingleProjectNode(in);
    }

    private static ClusterBlocks readFromSingleProjectNode(StreamInput in) throws IOException {
        Set<ClusterBlock> global = ClusterBlocks.readBlockSet(in);
        Map<String, Set<ClusterBlock>> indicesBlocks = in.readImmutableMap(i -> i.readString().intern(), ClusterBlocks::readBlockSet);
        if (global.isEmpty() && indicesBlocks.isEmpty()) {
            return EMPTY_CLUSTER_BLOCK;
        }
        if (indicesBlocks.isEmpty()) {
            return new ClusterBlocks(global, Map.of());
        }
        return new ClusterBlocks(global, Map.of(Metadata.DEFAULT_PROJECT_ID, new ProjectBlocks(indicesBlocks, Set.of())));
    }

    private static Set<ClusterBlock> readBlockSet(StreamInput in) throws IOException {
        return in.readCollectionAsImmutableSet(ClusterBlock::new);
    }

    public static Diff<ClusterBlocks> readDiffFrom(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            if (in.getTransportVersion().onOrAfter(TransportVersions.MULTI_PROJECT)) {
                return new ClusterBlocksDiff(ClusterBlocks.readFrom(in), false);
            }
            return new ClusterBlocksDiff(ClusterBlocks.readFromSingleProjectNode(in), true);
        }
        return SimpleDiffable.empty();
    }

    public ClusterBlocks initializeProjects(Set<ProjectId> projectIds) {
        if (projectIds.containsAll(this.projectBlocksMap.keySet())) {
            return this;
        }
        Builder builder = ClusterBlocks.builder(this);
        Sets.difference(this.projectBlocksMap.keySet(), projectIds).forEach(builder::removeProject);
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ClusterBlocks blocks) {
        return ClusterBlocks.builder().blocks(blocks);
    }

    public static class ProjectBlocks
    implements Writeable {
        static final ProjectBlocks EMPTY = new ProjectBlocks(Map.of(), Set.of());
        private final Map<String, Set<ClusterBlock>> indices;
        private final Set<ClusterBlock> projectGlobal;

        ProjectBlocks(Map<String, Set<ClusterBlock>> indices, Set<ClusterBlock> projectGlobal) {
            this.indices = indices;
            this.projectGlobal = projectGlobal;
        }

        public Map<String, Set<ClusterBlock>> indices() {
            return this.indices;
        }

        public Set<ClusterBlock> projectGlobals() {
            return this.projectGlobal;
        }

        Set<ClusterBlock> get(String index) {
            return this.indices.get(index);
        }

        public boolean isEmpty() {
            return this.indices.isEmpty() && this.projectGlobal.isEmpty();
        }

        static ProjectBlocks readFrom(StreamInput in) throws IOException {
            Map<String, Set<ClusterBlock>> indices = in.readImmutableMap(i -> i.readString().intern(), ClusterBlocks::readBlockSet);
            Set<ClusterBlock> projectGlobal = in.getTransportVersion().supports(PROJECT_DELETION_GLOBAL_BLOCK) ? ClusterBlocks.readBlockSet(in) : Set.of();
            return new ProjectBlocks(indices, projectGlobal);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.indices, (o, s) -> ClusterBlocks.writeBlockSet(s, o));
            if (out.getTransportVersion().supports(PROJECT_DELETION_GLOBAL_BLOCK)) {
                ClusterBlocks.writeBlockSet(this.projectGlobal, out);
            } else assert (this.projectGlobal.isEmpty()) : "Any MP-enabled cluster must be past TransportVersions.PROJECT_DELETION_GLOBAL_BLOCK";
        }
    }

    record ImmutableLevelHolder(Set<ClusterBlock> global, Map<ProjectId, ProjectBlocks> projects) {
    }

    private static class ClusterBlocksDiff
    implements Diff<ClusterBlocks> {
        private final ClusterBlocks part;
        private final boolean isFromSingleProjectNode;

        ClusterBlocksDiff(ClusterBlocks part, boolean isFromSingleProjectNode) {
            this.part = part;
            this.isFromSingleProjectNode = isFromSingleProjectNode;
        }

        @Override
        public ClusterBlocks apply(ClusterBlocks part) {
            if (this.isFromSingleProjectNode) {
                if (part.noProjectOrDefaultProjectOnly()) {
                    return this.part;
                }
                throw new IllegalStateException("Cannot apply BWC diff to cluster blocks with multiple projects: " + String.valueOf(part.projectBlocksMap.keySet()));
            }
            return this.part;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion().onOrAfter(TransportVersions.MULTI_PROJECT)) {
                out.writeBoolean(true);
                this.part.writeTo(out);
            } else if (this.part.noProjectOrDefaultProjectOnly()) {
                out.writeBoolean(true);
                this.part.writeToSingleProjectNode(out);
            } else {
                throw new IllegalStateException("Cannot write multi-project blocks diff to a stream with version [" + String.valueOf(out.getTransportVersion()) + "]");
            }
        }
    }

    public static class Builder {
        private final Set<ClusterBlock> global = new HashSet<ClusterBlock>();
        private final Map<ProjectId, ProjectBlocks> projects = new HashMap<ProjectId, ProjectBlocks>();

        private static ProjectBlocks emptyMutableProjectBlocks() {
            return new ProjectBlocks(new HashMap<String, Set<ClusterBlock>>(), new HashSet<ClusterBlock>());
        }

        public Builder blocks(ClusterBlocks blocks) {
            this.global.addAll(blocks.global());
            for (ProjectId projectId : blocks.projectBlocksMap.keySet()) {
                ProjectBlocks projectBlocks = this.projects.computeIfAbsent(projectId, k -> Builder.emptyMutableProjectBlocks());
                projectBlocks.projectGlobal.addAll(blocks.projectGlobal(projectId));
                for (Map.Entry<String, Set<ClusterBlock>> entry : blocks.indices(projectId).entrySet()) {
                    if (!projectBlocks.indices.containsKey(entry.getKey())) {
                        projectBlocks.indices.put(entry.getKey(), new HashSet());
                    }
                    projectBlocks.indices.get(entry.getKey()).addAll((Collection<ClusterBlock>)entry.getValue());
                }
            }
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder addBlocks(IndexMetadata indexMetadata) {
            return this.addBlocks(Metadata.DEFAULT_PROJECT_ID, indexMetadata);
        }

        public Builder addBlocks(ProjectId projectId, IndexMetadata indexMetadata) {
            String indexName = indexMetadata.getIndex().getName();
            if (indexMetadata.getState() == IndexMetadata.State.CLOSE) {
                this.addIndexBlock(projectId, indexName, MetadataIndexStateService.INDEX_CLOSED_BLOCK);
            }
            if (IndexMetadata.INDEX_READ_ONLY_SETTING.get(indexMetadata.getSettings()).booleanValue()) {
                this.addIndexBlock(projectId, indexName, IndexMetadata.INDEX_READ_ONLY_BLOCK);
            }
            if (IndexMetadata.INDEX_BLOCKS_READ_SETTING.get(indexMetadata.getSettings()).booleanValue()) {
                this.addIndexBlock(projectId, indexName, IndexMetadata.INDEX_READ_BLOCK);
            }
            if (IndexMetadata.INDEX_BLOCKS_WRITE_SETTING.get(indexMetadata.getSettings()).booleanValue()) {
                this.addIndexBlock(projectId, indexName, IndexMetadata.INDEX_WRITE_BLOCK);
            }
            if (IndexMetadata.INDEX_BLOCKS_METADATA_SETTING.get(indexMetadata.getSettings()).booleanValue()) {
                this.addIndexBlock(projectId, indexName, IndexMetadata.INDEX_METADATA_BLOCK);
            }
            if (IndexMetadata.INDEX_BLOCKS_READ_ONLY_ALLOW_DELETE_SETTING.get(indexMetadata.getSettings()).booleanValue()) {
                this.addIndexBlock(projectId, indexName, IndexMetadata.INDEX_READ_ONLY_ALLOW_DELETE_BLOCK);
            }
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder updateBlocks(IndexMetadata indexMetadata) {
            return this.updateBlocks(Metadata.DEFAULT_PROJECT_ID, indexMetadata);
        }

        public Builder updateBlocks(ProjectId projectId, IndexMetadata indexMetadata) {
            this.projects.computeIfAbsent((ProjectId)projectId, (Function<ProjectId, ProjectBlocks>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$updateBlocks$1(org.elasticsearch.cluster.metadata.ProjectId ), (Lorg/elasticsearch/cluster/metadata/ProjectId;)Lorg/elasticsearch/cluster/block/ClusterBlocks$ProjectBlocks;)()).indices.remove(indexMetadata.getIndex().getName());
            return this.addBlocks(projectId, indexMetadata);
        }

        public Builder addGlobalBlock(ClusterBlock block) {
            this.global.add(block);
            return this;
        }

        public Builder removeGlobalBlock(ClusterBlock block) {
            this.global.remove(block);
            return this;
        }

        public Builder removeGlobalBlock(int blockId) {
            this.global.removeIf(block -> block.id() == blockId);
            return this;
        }

        public Builder removeProject(ProjectId projectId) {
            this.projects.remove(projectId);
            return this;
        }

        public Builder addProjectGlobalBlock(ProjectId projectId, ClusterBlock block) {
            assert (!projectId.equals(ProjectId.DEFAULT));
            this.projects.computeIfAbsent((ProjectId)projectId, (Function<ProjectId, ProjectBlocks>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$addProjectGlobalBlock$3(org.elasticsearch.cluster.metadata.ProjectId ), (Lorg/elasticsearch/cluster/metadata/ProjectId;)Lorg/elasticsearch/cluster/block/ClusterBlocks$ProjectBlocks;)()).projectGlobal.add(block);
            return this;
        }

        public Builder removeProjectGlobalBlock(ProjectId projectId, ClusterBlock block) {
            ProjectBlocks project = this.projects.get(projectId);
            if (project != null) {
                project.projectGlobal.remove(block);
            }
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder addIndexBlock(String index, ClusterBlock block) {
            return this.addIndexBlock(Metadata.DEFAULT_PROJECT_ID, index, block);
        }

        public Builder addIndexBlock(ProjectId projectId, String index, ClusterBlock block) {
            ProjectBlocks projectBlocks = this.projects.computeIfAbsent(projectId, k -> Builder.emptyMutableProjectBlocks());
            if (!projectBlocks.indices().containsKey(index)) {
                projectBlocks.indices.put(index, new HashSet());
            }
            projectBlocks.indices.get(index).add(block);
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder removeIndexBlocks(String index) {
            return this.removeIndexBlocks(Metadata.DEFAULT_PROJECT_ID, index);
        }

        public Builder removeIndexBlocks(ProjectId projectId, String index) {
            ProjectBlocks projectBlocks = this.projects.get(projectId);
            if (projectBlocks == null) {
                return this;
            }
            if (!projectBlocks.indices.containsKey(index)) {
                return this;
            }
            projectBlocks.indices.remove(index);
            return this;
        }

        public boolean hasIndexBlock(ProjectId projectId, String index, ClusterBlock block) {
            ProjectBlocks projectBlocks = this.projects.get(projectId);
            if (projectBlocks == null) {
                return false;
            }
            return projectBlocks.indices.getOrDefault(index, Set.of()).contains(block);
        }

        public boolean hasIndexBlockLevel(ProjectId projectId, String index, ClusterBlockLevel level) {
            ProjectBlocks projectBlocks = this.projects.get(projectId);
            if (projectBlocks == null) {
                return false;
            }
            return projectBlocks.indices.getOrDefault(index, Set.of()).stream().anyMatch(clusterBlock -> clusterBlock.contains(level));
        }

        public Builder removeIndexBlock(ProjectId projectId, String index, ClusterBlock block) {
            ProjectBlocks projectBlocks = this.projects.get(projectId);
            if (projectBlocks == null) {
                return this;
            }
            if (!projectBlocks.indices.containsKey(index)) {
                return this;
            }
            projectBlocks.get(index).remove(block);
            if (projectBlocks.get(index).isEmpty()) {
                projectBlocks.indices.remove(index);
            }
            return this;
        }

        public Builder removeIndexBlockWithId(ProjectId projectId, String index, int blockId) {
            ProjectBlocks projectBlocks = this.projects.get(projectId);
            if (projectBlocks == null) {
                return this;
            }
            Set<ClusterBlock> indexBlocks = projectBlocks.get(index);
            if (indexBlocks == null) {
                return this;
            }
            indexBlocks.removeIf(block -> block.id() == blockId);
            if (indexBlocks.isEmpty()) {
                projectBlocks.indices.remove(index);
            }
            return this;
        }

        public ClusterBlocks build() {
            if (this.global.isEmpty() && ClusterBlocks.noProjectOrDefaultProjectOnly(this.projects) && this.projects.getOrDefault(Metadata.DEFAULT_PROJECT_ID, ProjectBlocks.EMPTY).isEmpty()) {
                return EMPTY_CLUSTER_BLOCK;
            }
            HashMap<ProjectId, ProjectBlocks> projectsBuilder = new HashMap<ProjectId, ProjectBlocks>(this.projects.size());
            for (Map.Entry<ProjectId, ProjectBlocks> projectEntry : this.projects.entrySet()) {
                HashMap indicesBuilder = new HashMap(projectEntry.getValue().indices.size());
                for (Map.Entry<String, Set<ClusterBlock>> indexEntry : projectEntry.getValue().indices.entrySet()) {
                    indicesBuilder.put(indexEntry.getKey(), Set.copyOf((Collection)indexEntry.getValue()));
                }
                if (indicesBuilder.isEmpty() && projectEntry.getValue().projectGlobals().isEmpty()) continue;
                projectsBuilder.put(projectEntry.getKey(), new ProjectBlocks(Map.copyOf(indicesBuilder), Set.copyOf(projectEntry.getValue().projectGlobals())));
            }
            return new ClusterBlocks(Set.copyOf(this.global), Map.copyOf(projectsBuilder));
        }

        private static /* synthetic */ ProjectBlocks lambda$addProjectGlobalBlock$3(ProjectId k) {
            return Builder.emptyMutableProjectBlocks();
        }

        private static /* synthetic */ ProjectBlocks lambda$updateBlocks$1(ProjectId k) {
            return Builder.emptyMutableProjectBlocks();
        }
    }
}

