/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.broadcast.unpromotable;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.shard.ShardId;

public class BroadcastUnpromotableRequest
extends LegacyActionRequest
implements IndicesRequest {
    @Nullable
    final IndexShardRoutingTable indexShardRoutingTable;
    protected final ShardId shardId;
    protected final String[] indices;
    protected final boolean failShardOnError;

    public BroadcastUnpromotableRequest(StreamInput in) throws IOException {
        super(in);
        this.indexShardRoutingTable = null;
        this.shardId = new ShardId(in);
        this.indices = new String[]{this.shardId.getIndex().getName()};
        this.failShardOnError = in.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X) && in.readBoolean();
    }

    public BroadcastUnpromotableRequest(IndexShardRoutingTable indexShardRoutingTable) {
        this(indexShardRoutingTable, false);
    }

    public BroadcastUnpromotableRequest(IndexShardRoutingTable indexShardRoutingTable, boolean failShardOnError) {
        this.indexShardRoutingTable = Objects.requireNonNull(indexShardRoutingTable, "index shard routing table is null");
        this.shardId = indexShardRoutingTable.shardId();
        this.indices = new String[]{this.shardId.getIndex().getName()};
        this.failShardOnError = failShardOnError;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.shardId == null) {
            validationException = ValidateActions.addValidationError("shard id is missing", validationException);
        }
        return validationException;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeWriteable(this.shardId);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_8_0)) {
            out.writeBoolean(this.failShardOnError);
        }
    }

    @Override
    public String toString() {
        return "BroadcastUnpromotableRequest{shardId=" + String.valueOf(this.shardId()) + "}";
    }

    @Override
    public String getDescription() {
        return this.toString();
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    public boolean failShardOnError() {
        return this.failShardOnError;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
    }
}

