/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesFailure;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;

public class FieldCapabilitiesResponse
extends ActionResponse
implements ChunkedToXContentObject {
    public static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
    public static final ParseField FIELDS_FIELD = new ParseField("fields", new String[0]);
    private static final ParseField FAILED_INDICES_FIELD = new ParseField("failed_indices", new String[0]);
    public static final ParseField FAILURES_FIELD = new ParseField("failures", new String[0]);
    private final String[] indices;
    private final Map<String, Map<String, FieldCapabilities>> fields;
    private final List<FieldCapabilitiesFailure> failures;
    private final List<FieldCapabilitiesIndexResponse> indexResponses;

    public FieldCapabilitiesResponse(String[] indices, Map<String, Map<String, FieldCapabilities>> fields, List<FieldCapabilitiesFailure> failures) {
        this(indices, fields, Collections.emptyList(), failures);
    }

    public FieldCapabilitiesResponse(String[] indices, Map<String, Map<String, FieldCapabilities>> fields) {
        this(indices, fields, Collections.emptyList(), Collections.emptyList());
    }

    public FieldCapabilitiesResponse(List<FieldCapabilitiesIndexResponse> indexResponses, List<FieldCapabilitiesFailure> failures) {
        this(Strings.EMPTY_ARRAY, Collections.emptyMap(), indexResponses, failures);
    }

    private FieldCapabilitiesResponse(String[] indices, Map<String, Map<String, FieldCapabilities>> fields, List<FieldCapabilitiesIndexResponse> indexResponses, List<FieldCapabilitiesFailure> failures) {
        this.fields = Objects.requireNonNull(fields);
        this.indexResponses = Objects.requireNonNull(indexResponses);
        this.indices = indices;
        this.failures = failures;
    }

    public FieldCapabilitiesResponse(StreamInput in) throws IOException {
        this.indices = in.readStringArray();
        this.fields = in.readMap(FieldCapabilitiesResponse::readField);
        this.indexResponses = FieldCapabilitiesIndexResponse.readList(in);
        this.failures = in.readCollectionAsList(FieldCapabilitiesFailure::new);
    }

    public String[] getIndices() {
        return this.indices;
    }

    public int getFailedIndicesCount() {
        int count = 0;
        for (FieldCapabilitiesFailure fieldCapabilitiesFailure : this.failures) {
            int length = fieldCapabilitiesFailure.getIndices().length;
            count += length;
        }
        return count;
    }

    public Map<String, Map<String, FieldCapabilities>> get() {
        return this.fields;
    }

    public List<FieldCapabilitiesFailure> getFailures() {
        return this.failures;
    }

    public List<FieldCapabilitiesIndexResponse> getIndexResponses() {
        return this.indexResponses;
    }

    public Map<String, FieldCapabilities> getField(String field) {
        return this.fields.get(field);
    }

    public boolean isMetadataField(String field) {
        Map<String, FieldCapabilities> caps = this.getField(field);
        if (caps == null) {
            return false;
        }
        return caps.values().stream().anyMatch(FieldCapabilities::isMetadataField);
    }

    private static Map<String, FieldCapabilities> readField(StreamInput in) throws IOException {
        return in.readMap(FieldCapabilities::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringArray(this.indices);
        out.writeMap(this.fields, FieldCapabilitiesResponse::writeField);
        FieldCapabilitiesIndexResponse.writeList(out, this.indexResponses);
        out.writeCollection(this.failures);
    }

    private static void writeField(StreamOutput out, Map<String, FieldCapabilities> map) throws IOException {
        out.writeMap(map, StreamOutput::writeWriteable);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        if (this.indexResponses.size() > 0) {
            throw new IllegalStateException("cannot serialize non-merged response");
        }
        return Iterators.concat(Iterators.single((b, p) -> b.startObject().array(INDICES_FIELD.getPreferredName(), this.indices).startObject(FIELDS_FIELD.getPreferredName())), Iterators.map(this.fields.entrySet().iterator(), r -> (b, p) -> b.xContentValuesMap((String)r.getKey(), (Map)r.getValue())), this.failures.size() > 0 ? Iterators.concat(Iterators.single((b, p) -> b.endObject().field(FAILED_INDICES_FIELD.getPreferredName(), this.getFailedIndicesCount()).field(FAILURES_FIELD.getPreferredName()).startArray()), this.failures.iterator(), Iterators.single((b, p) -> b.endArray().endObject())) : Iterators.single((b, p) -> b.endObject().endObject()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldCapabilitiesResponse that = (FieldCapabilitiesResponse)o;
        return Arrays.equals(this.indices, that.indices) && Objects.equals(this.fields, that.fields) && Objects.equals(this.indexResponses, that.indexResponses) && Objects.equals(this.failures, that.failures);
    }

    public int hashCode() {
        int result = Objects.hash(this.fields, this.indexResponses, this.failures);
        result = 31 * result + Arrays.hashCode(this.indices);
        return result;
    }

    public String toString() {
        if (this.indexResponses.size() > 0) {
            return "FieldCapabilitiesResponse{unmerged}";
        }
        return Strings.toString(this);
    }
}

