/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration.ingest;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.elasticsearch.logstashbridge.core.IOUtilsBridge;
import org.elasticsearch.logstashbridge.ingest.ProcessorFactoryBridge;
import org.elasticsearch.logstashbridge.ingest.ProcessorParametersBridge;
import org.elasticsearch.logstashbridge.plugins.IngestPluginBridge;

public class SafeSubsetIngestPlugin
implements IngestPluginBridge,
Closeable {
    private final IngestPluginBridge ingestPlugin;
    private final Set<String> requiredProcessors;

    public static Supplier<IngestPluginBridge> safeSubset(@Nonnull Supplier<IngestPluginBridge> ingestPluginSupplier, @Nonnull Set<String> requiredProcessors) {
        return () -> new SafeSubsetIngestPlugin(ingestPluginSupplier, requiredProcessors);
    }

    private SafeSubsetIngestPlugin(@Nonnull Supplier<IngestPluginBridge> ingestPluginSupplier, @Nonnull Set<String> requiredProcessors) {
        try {
            this.ingestPlugin = Objects.requireNonNull(ingestPluginSupplier.get(), "an IngestPlugin must be supplied!");
            this.requiredProcessors = Set.copyOf(requiredProcessors);
        }
        catch (Exception e) {
            IOUtilsBridge.closeWhileHandlingException(this);
            throw e;
        }
    }

    @Override
    public Map<String, ProcessorFactoryBridge> getProcessors(ProcessorParametersBridge parameters) {
        Map<String, ProcessorFactoryBridge> providedProcessors = this.ingestPlugin.getProcessors(parameters);
        HashMap<String, ProcessorFactoryBridge> acceptedProcessors = new HashMap<String, ProcessorFactoryBridge>();
        HashSet<String> missingProcessors = new HashSet<String>();
        for (String requiredProcessor : this.requiredProcessors) {
            ProcessorFactoryBridge processor = providedProcessors.get(requiredProcessor);
            if (!Objects.nonNull(processor)) {
                missingProcessors.add(requiredProcessor);
                continue;
            }
            acceptedProcessors.put(requiredProcessor, processor);
        }
        if (!missingProcessors.isEmpty()) {
            throw new IllegalStateException(String.format("Expected IngestPlugin %s to provide processors %s, but they were not provided", this.ingestPlugin, missingProcessors));
        }
        return Map.copyOf(acceptedProcessors);
    }

    @Override
    public void close() throws IOException {
        if (this.ingestPlugin instanceof Closeable) {
            ((Closeable)((Object)this.ingestPlugin)).close();
        }
    }
}

