/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.FieldMemoryUsage;
import co.elastic.clients.elasticsearch._types.GlobalOrdinalsStats;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FielddataStats
implements JsonpSerializable {
    @Nullable
    private final Long evictions;
    @Nullable
    private final String memorySize;
    private final long memorySizeInBytes;
    private final Map<String, FieldMemoryUsage> fields;
    private final GlobalOrdinalsStats globalOrdinals;
    public static final JsonpDeserializer<FielddataStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FielddataStats::setupFielddataStatsDeserializer);

    private FielddataStats(Builder builder) {
        this.evictions = builder.evictions;
        this.memorySize = builder.memorySize;
        this.memorySizeInBytes = ApiTypeHelper.requireNonNull(builder.memorySizeInBytes, (Object)this, "memorySizeInBytes", 0L);
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
        this.globalOrdinals = ApiTypeHelper.requireNonNull(builder.globalOrdinals, this, "globalOrdinals");
    }

    public static FielddataStats of(Function<Builder, ObjectBuilder<FielddataStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long evictions() {
        return this.evictions;
    }

    @Nullable
    public final String memorySize() {
        return this.memorySize;
    }

    public final long memorySizeInBytes() {
        return this.memorySizeInBytes;
    }

    public final Map<String, FieldMemoryUsage> fields() {
        return this.fields;
    }

    public final GlobalOrdinalsStats globalOrdinals() {
        return this.globalOrdinals;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.evictions != null) {
            generator.writeKey("evictions");
            generator.write(this.evictions);
        }
        if (this.memorySize != null) {
            generator.writeKey("memory_size");
            generator.write(this.memorySize);
        }
        generator.writeKey("memory_size_in_bytes");
        generator.write(this.memorySizeInBytes);
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry<String, FieldMemoryUsage> item0 : this.fields.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("global_ordinals");
        this.globalOrdinals.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupFielddataStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::evictions, JsonpDeserializer.longDeserializer(), "evictions");
        op.add(Builder::memorySize, JsonpDeserializer.stringDeserializer(), "memory_size");
        op.add(Builder::memorySizeInBytes, JsonpDeserializer.longDeserializer(), "memory_size_in_bytes");
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(FieldMemoryUsage._DESERIALIZER), "fields");
        op.add(Builder::globalOrdinals, GlobalOrdinalsStats._DESERIALIZER, "global_ordinals");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FielddataStats> {
        @Nullable
        private Long evictions;
        @Nullable
        private String memorySize;
        private Long memorySizeInBytes;
        @Nullable
        private Map<String, FieldMemoryUsage> fields;
        private GlobalOrdinalsStats globalOrdinals;

        public final Builder evictions(@Nullable Long value) {
            this.evictions = value;
            return this;
        }

        public final Builder memorySize(@Nullable String value) {
            this.memorySize = value;
            return this;
        }

        public final Builder memorySizeInBytes(long value) {
            this.memorySizeInBytes = value;
            return this;
        }

        public final Builder fields(Map<String, FieldMemoryUsage> map) {
            this.fields = Builder._mapPutAll(this.fields, map);
            return this;
        }

        public final Builder fields(String key, FieldMemoryUsage value) {
            this.fields = Builder._mapPut(this.fields, key, value);
            return this;
        }

        public final Builder fields(String key, Function<FieldMemoryUsage.Builder, ObjectBuilder<FieldMemoryUsage>> fn) {
            return this.fields(key, fn.apply(new FieldMemoryUsage.Builder()).build());
        }

        public final Builder globalOrdinals(GlobalOrdinalsStats value) {
            this.globalOrdinals = value;
            return this;
        }

        public final Builder globalOrdinals(Function<GlobalOrdinalsStats.Builder, ObjectBuilder<GlobalOrdinalsStats>> fn) {
            return this.globalOrdinals(fn.apply(new GlobalOrdinalsStats.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FielddataStats build() {
            this._checkSingleUse();
            return new FielddataStats(this);
        }
    }
}

