"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CAPABILITIES = exports.BASE_PATH = exports.ATTACK_DISCOVERY_EVENT_PROVIDER = exports.ATTACK_DISCOVERY_EVENT_LOG_ACTION_GENERATION_SUCCEEDED = exports.ATTACK_DISCOVERY_EVENT_LOG_ACTION_GENERATION_STARTED = exports.ATTACK_DISCOVERY_EVENT_LOG_ACTION_GENERATION_FAILED = exports.ATTACK_DISCOVERY_EVENT_LOG_ACTION_GENERATION_DISMISSED = exports.ATTACK_DISCOVERY_EVENT_LOG_ACTION_GENERATION_CANCELED = exports.ATTACK_DISCOVERY_EVENT_ACTIONS = exports.ANONYMIZATION_FIELDS_TABLE_MAX_PAGE_SIZE = void 0;
Object.defineProperty(exports, "CASES_FEATURE_ID", {
  enumerable: true,
  get: function () {
    return _constants.CASES_FEATURE_ID_V3;
  }
});
exports.PROMPTS_TABLE_MAX_PAGE_SIZE = exports.PLUGIN_NAME = exports.PLUGIN_ID = exports.MINIMUM_AI_ASSISTANT_LICENSE = exports.KNOWLEDGE_BASE_ENTRIES_TABLE_MAX_PAGE_SIZE = exports.DEFAULT_DATE_FORMAT_TZ = exports.CONVERSATIONS_TABLE_MAX_PAGE_SIZE = void 0;
Object.defineProperty(exports, "SECURITY_FEATURE_ID", {
  enumerable: true,
  get: function () {
    return _constants.SECURITY_FEATURE_ID_V4;
  }
});
var _constants = require("@kbn/security-solution-features/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PLUGIN_ID = exports.PLUGIN_ID = 'elasticAssistant';
const PLUGIN_NAME = exports.PLUGIN_NAME = 'elasticAssistant';
const BASE_PATH = exports.BASE_PATH = '/internal/elastic_assistant';
const CONVERSATIONS_TABLE_MAX_PAGE_SIZE = exports.CONVERSATIONS_TABLE_MAX_PAGE_SIZE = 100;
const ANONYMIZATION_FIELDS_TABLE_MAX_PAGE_SIZE = exports.ANONYMIZATION_FIELDS_TABLE_MAX_PAGE_SIZE = 100;
const PROMPTS_TABLE_MAX_PAGE_SIZE = exports.PROMPTS_TABLE_MAX_PAGE_SIZE = 100;

// Event log
const ATTACK_DISCOVERY_EVENT_PROVIDER = exports.ATTACK_DISCOVERY_EVENT_PROVIDER = 'securitySolution.attackDiscovery';
const ATTACK_DISCOVERY_EVENT_LOG_ACTION_GENERATION_STARTED = exports.ATTACK_DISCOVERY_EVENT_LOG_ACTION_GENERATION_STARTED = 'generation-started';
const ATTACK_DISCOVERY_EVENT_LOG_ACTION_GENERATION_SUCCEEDED = exports.ATTACK_DISCOVERY_EVENT_LOG_ACTION_GENERATION_SUCCEEDED = 'generation-succeeded';
const ATTACK_DISCOVERY_EVENT_LOG_ACTION_GENERATION_FAILED = exports.ATTACK_DISCOVERY_EVENT_LOG_ACTION_GENERATION_FAILED = 'generation-failed';
const ATTACK_DISCOVERY_EVENT_LOG_ACTION_GENERATION_CANCELED = exports.ATTACK_DISCOVERY_EVENT_LOG_ACTION_GENERATION_CANCELED = 'generation-canceled';
const ATTACK_DISCOVERY_EVENT_LOG_ACTION_GENERATION_DISMISSED = exports.ATTACK_DISCOVERY_EVENT_LOG_ACTION_GENERATION_DISMISSED = 'generation-dismissed';
const ATTACK_DISCOVERY_EVENT_ACTIONS = exports.ATTACK_DISCOVERY_EVENT_ACTIONS = [ATTACK_DISCOVERY_EVENT_LOG_ACTION_GENERATION_STARTED, ATTACK_DISCOVERY_EVENT_LOG_ACTION_GENERATION_SUCCEEDED, ATTACK_DISCOVERY_EVENT_LOG_ACTION_GENERATION_FAILED, ATTACK_DISCOVERY_EVENT_LOG_ACTION_GENERATION_CANCELED, ATTACK_DISCOVERY_EVENT_LOG_ACTION_GENERATION_DISMISSED];

// Knowledge Base
const KNOWLEDGE_BASE_ENTRIES_TABLE_MAX_PAGE_SIZE = exports.KNOWLEDGE_BASE_ENTRIES_TABLE_MAX_PAGE_SIZE = 100;

// Capabilities
const CAPABILITIES = exports.CAPABILITIES = `${BASE_PATH}/capabilities`;

/**
 Licensing requirements
 */
const MINIMUM_AI_ASSISTANT_LICENSE = exports.MINIMUM_AI_ASSISTANT_LICENSE = 'enterprise';
const DEFAULT_DATE_FORMAT_TZ = exports.DEFAULT_DATE_FORMAT_TZ = 'dateFormat:tz';