"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRecommendedFields = exports.DEFAULT_LOGS_RECOMMENDED_FIELD_NAMES = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// Field names that should always be surfaced in the UI for logs data.
const DEFAULT_LOGS_RECOMMENDED_FIELD_NAMES = exports.DEFAULT_LOGS_RECOMMENDED_FIELD_NAMES = ['event.dataset', 'service.name', 'host.name', 'message', 'log.level'];
const createRecommendedFields = ({
  defaultFields
}) => {
  return prev => () => ({
    ...(prev ? prev() : {}),
    recommendedFields: defaultFields !== null && defaultFields !== void 0 ? defaultFields : DEFAULT_LOGS_RECOMMENDED_FIELD_NAMES
  });
};
exports.createRecommendedFields = createRecommendedFields;