"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Table = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _translations = require("../../../../common/translations");
var _hooks = require("../../../hooks");
var _descriptive_switch = require("../../common/descriptive_switch");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality/table/table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Table = () => {
  const {
    sort,
    onTableChange,
    pagination,
    renderedItems,
    columns,
    loading,
    resultsCount,
    showInactiveDatasets,
    showFullDatasetNames,
    canUserMonitorAnyDataset,
    canUserMonitorAnyDataStream,
    toggleInactiveDatasets,
    toggleFullDatasetNames
  } = (0, _hooks.useDatasetQualityTable)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.datasetQuality.tableSummary",
    defaultMessage: "Showing {items} Datasets",
    values: {
      items: resultsCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_descriptive_switch.DescriptiveSwitch, {
    testSubject: "datasetQualityFullDatasetNameSwitch",
    label: _translations.fullDatasetNameLabel,
    checked: showFullDatasetNames,
    tooltipText: _translations.fullDatasetNameDescription,
    onToggle: toggleFullDatasetNames,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 11
    }
  }), canUserMonitorAnyDataset && canUserMonitorAnyDataStream && /*#__PURE__*/_react.default.createElement(_descriptive_switch.DescriptiveSwitch, {
    testSubject: "datasetQualityInactiveDatasetsSwitch",
    label: _translations.inactiveDatasetsLabel,
    checked: showInactiveDatasets,
    tooltipText: _translations.inactiveDatasetsDescription,
    onToggle: toggleInactiveDatasets,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    css: {
      height: 2
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    tableLayout: "auto",
    sorting: sort,
    onChange: onTableChange,
    pagination: pagination,
    "data-test-subj": "datasetQualityTable",
    rowProps: {
      'data-test-subj': 'datasetQualityTableRow'
    },
    items: renderedItems,
    columns: columns,
    loading: loading,
    noItemsMessage: loading ? _translations.loadingDatasetsText : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      "data-test-subj": "datasetQualityTableNoData",
      layout: "vertical",
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 22
        }
      }, _translations.noDatasetsTitle),
      hasBorder: false,
      titleSize: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }));
};

// Allow for lazy loading
// eslint-disable-next-line import/no-default-export
exports.Table = Table;
var _default = exports.default = Table;