"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindFileStructurePermissionDenied = exports.FileTooLarge = exports.FileCouldNotBeRead = exports.Explanation = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/file_data_visualizer/new/file_status/file_error_callouts.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FileTooLarge = ({
  fileStatus
}) => {
  const {
    diffFormatted,
    maxFileSizeFormatted,
    fileSizeFormatted
  } = fileStatus.fileSizeInfo;

  // Format the byte values, using the second format if the difference between
  // the file size and the max is so small that the formatted values are identical
  // e.g. 100.01 MB and 100.0 MB
  let errorText;
  if (fileSizeFormatted !== maxFileSizeFormatted) {
    errorText = /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.fileErrorCallouts.fileSizeExceedsAllowedSizeErrorMessage",
      defaultMessage: "The size of the file you selected for upload is {fileSizeFormatted} which exceeds the maximum permitted size of {maxFileSizeFormatted}",
      values: {
        fileSizeFormatted,
        maxFileSizeFormatted
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 9
      }
    }));
  } else {
    errorText = /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.fileErrorCallouts.fileSizeExceedsAllowedSizeByDiffFormatErrorMessage",
      defaultMessage: "The size of the file you selected for upload exceeds the maximum permitted size of {maxFileSizeFormatted} by {diffFormatted}",
      values: {
        maxFileSizeFormatted,
        diffFormatted
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.fileErrorCallouts.fileSizeTooLargeTitle",
      defaultMessage: "File size is too large",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 9
      }
    }),
    color: "danger",
    iconType: "cross",
    "data-test-subj": "dataVisualizerFileUploadErrorCallout fileTooLarge",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, errorText);
};
exports.FileTooLarge = FileTooLarge;
const FileCouldNotBeRead = ({
  error,
  loaded,
  showEditFlyout
}) => {
  var _error$body;
  const message = (error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) || '';
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.fileErrorCallouts.fileCouldNotBeReadTitle",
      defaultMessage: "File structure cannot be determined",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 11
      }
    }),
    color: "danger",
    iconType: "cross",
    "data-test-subj": "dataVisualizerFileUploadErrorCallout fileCouldNotBeRead",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }, loaded === false && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.fileErrorCallouts.applyOverridesDescription",
    defaultMessage: "If you know something about this data, such as the file format or timestamp format, adding initial overrides may help us to infer the rest of the structure.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement("br", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: showEditFlyout,
    flush: "left",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.fileErrorCallouts.overrideButton",
    defaultMessage: "Apply override settings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 13
    }
  })), message, /*#__PURE__*/_react.default.createElement(Explanation, {
    error: error,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  }), loaded && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.fileErrorCallouts.revertingToPreviousSettingsDescription",
    defaultMessage: "Reverting to previous settings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 13
    }
  }))));
};
exports.FileCouldNotBeRead = FileCouldNotBeRead;
const Explanation = ({
  error
}) => {
  var _error$body2, _error$body2$attribut, _error$body2$attribut2, _error$body2$attribut3, _error$body2$attribut4;
  if (!(error !== null && error !== void 0 && (_error$body2 = error.body) !== null && _error$body2 !== void 0 && (_error$body2$attribut = _error$body2.attributes) !== null && _error$body2$attribut !== void 0 && (_error$body2$attribut2 = _error$body2$attribut.body) !== null && _error$body2$attribut2 !== void 0 && (_error$body2$attribut3 = _error$body2$attribut2.error) !== null && _error$body2$attribut3 !== void 0 && (_error$body2$attribut4 = _error$body2$attribut3.suppressed) !== null && _error$body2$attribut4 !== void 0 && _error$body2$attribut4.length)) {
    return null;
  }
  const reason = error.body.attributes.body.error.suppressed[0].reason;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }), reason.split('\n').map((m, i) => /*#__PURE__*/_react.default.createElement("div", {
    key: i,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 9
    }
  }, m)));
};
exports.Explanation = Explanation;
const FindFileStructurePermissionDenied = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.fileErrorCallouts.findFileStructurePermissionDenied.title",
      defaultMessage: "Permission denied",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 11
      }
    }),
    color: "danger",
    iconType: "cross",
    "data-test-subj": "dataVisualizerFileStructurePermissionDeniedErrorCallout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.fileErrorCallouts.findFileStructurePermissionDenied.description",
    defaultMessage: "You do not have sufficient privileges to analyze files.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 9
    }
  })));
};
exports.FindFileStructurePermissionDenied = FindFileStructurePermissionDenied;