"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HistogramFormatEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _default = require("../default/default");
var _samples = require("../../samples");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_field_editor/public/components/field_format_editor/editors/histogram/histogram.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class HistogramFormatEditor extends _default.DefaultFormatEditor {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      ..._default.defaultState,
      sampleInputs: [50.1234, 100.0001, 99.9999, {
        values: [0.00001, 99.9999, 200, 300],
        counts: [573, 102, 482]
      }]
    });
  }
  render() {
    var _formatParams$params$, _formatParams$params;
    const {
      formatParams
    } = this.props;
    const {
      error,
      samples
    } = this.state;
    const numberOptions = [{
      value: 'number',
      text: _i18n.i18n.translate('indexPatternFieldEditor.histogram.subFormat.number', {
        defaultMessage: 'Number'
      })
    }, {
      value: 'bytes',
      text: _i18n.i18n.translate('indexPatternFieldEditor.histogram.subFormat.bytes', {
        defaultMessage: 'Bytes'
      })
    }, {
      value: 'percent',
      text: _i18n.i18n.translate('indexPatternFieldEditor.histogram.subFormat.percent', {
        defaultMessage: 'Percentage'
      })
    }];
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('indexPatternFieldEditor.histogram.histogramAsNumberLabel', {
        defaultMessage: 'Aggregated number format'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      options: numberOptions,
      value: formatParams.id || 'number',
      onChange: e => {
        this.onChange({
          id: e.target.value
        });
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('indexPatternFieldEditor.histogram.numeralLabel', {
        defaultMessage: 'Numeral format pattern (optional)'
      }),
      helpText: /*#__PURE__*/_react.default.createElement("span", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: "https://adamwdraper.github.io/Numeral-js/",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.number.documentationLabel",
        defaultMessage: "Documentation",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 17
        }
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "link",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 87,
          columnNumber: 17
        }
      }))),
      isInvalid: !!error,
      error: error,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: (_formatParams$params$ = formatParams === null || formatParams === void 0 ? void 0 : (_formatParams$params = formatParams.params) === null || _formatParams$params === void 0 ? void 0 : _formatParams$params.pattern) !== null && _formatParams$params$ !== void 0 ? _formatParams$params$ : '',
      onChange: e => {
        this.onChange({
          params: {
            pattern: e.target.value
          }
        });
      },
      isInvalid: !!error,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_samples.FormatEditorSamples, {
      samples: samples,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 9
      }
    }));
  }
}
exports.HistogramFormatEditor = HistogramFormatEditor;
(0, _defineProperty2.default)(HistogramFormatEditor, "formatId", _constants.formatId);