"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findSharedOriginObjects = findSharedOriginObjects;
var esKuery = _interopRequireWildcard(require("@kbn/es-query"));
var _coreSavedObjectsUtilsServer = require("@kbn/core-saved-objects-utils-server");
var _coreSavedObjectsBaseServerInternal = require("@kbn/core-saved-objects-base-server-internal");
var _functions = require("@kbn/es-query/src/kuery/functions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Fetches all objects with a shared origin, returning a map of the matching aliases and what space(s) they exist in.
 *
 * @internal
 */
async function findSharedOriginObjects(createPointInTimeFinder, objects, perPage, purpose) {
  if (!objects.length) {
    return new Map();
  }
  const uniqueObjectTypes = objects.reduce((acc, {
    type
  }) => acc.add(type), new Set());
  const filter = createOriginKueryFilter(objects, purpose);
  const finder = createPointInTimeFinder({
    type: [...uniqueObjectTypes],
    perPage,
    filter,
    fields: ['not-a-field'],
    // Specify a non-existent field to avoid fetching all type-level fields (we only care about root-level fields)
    namespaces: [_coreSavedObjectsUtilsServer.ALL_NAMESPACES_STRING] // We need to search across all spaces to have accurate results
  }, undefined, {
    disableExtensions: true
  });
  // NOTE: this objectsMap is only used internally (not in an API that is documented for public consumption), and it contains the minimal
  // amount of information to satisfy our UI needs today. We will need to change this in the future when we implement merging in #130311.
  const objectsMap = new Map();
  let error;
  try {
    for await (const {
      saved_objects: savedObjects
    } of finder.find()) {
      for (const savedObject of savedObjects) {
        var _objectsMap$get;
        const {
          type,
          id,
          originId,
          namespaces = []
        } = savedObject;
        const key = (0, _coreSavedObjectsBaseServerInternal.getObjectKey)({
          type,
          id: originId || id
        });
        const val = (_objectsMap$get = objectsMap.get(key)) !== null && _objectsMap$get !== void 0 ? _objectsMap$get : new Set();
        const filteredNamespaces = namespaces.includes(_coreSavedObjectsUtilsServer.ALL_NAMESPACES_STRING) || val.has(_coreSavedObjectsUtilsServer.ALL_NAMESPACES_STRING) ? [_coreSavedObjectsUtilsServer.ALL_NAMESPACES_STRING] : [...val, ...namespaces];
        objectsMap.set(key, new Set([...filteredNamespaces]));
      }
    }
  } catch (e) {
    error = e;
  }
  try {
    await finder.close();
  } catch (e) {
    if (!error) {
      error = e;
    }
  }
  if (error) {
    throw new Error(`Failed to retrieve shared origin objects: ${error.message}`);
  }
  return objectsMap;
}
function createOriginKueryFilter(objects, purpose) {
  const {
    buildNode
  } = esKuery.nodeTypes.function;
  // Note: these nodes include '.attributes' for type-level fields because these are eventually passed to `validateConvertFilterToKueryNode`, which requires it
  const kueryNodes = objects.reduce((acc, {
    type,
    id,
    origin
  }) => {
    // Escape Kuery values to prevent parsing errors and unintended behavior (object types/IDs can contain KQL special characters/operators)

    // Look for objects with an ID that matches the origin or ID (has a `type:` prefix)
    const idMatchesOrigin = buildNode(_functions.KQL_FUNCTION_IS, `${type}.id`, esKuery.escapeKuery(`${type}:${origin || id}`));

    // Look for objects with an `originId` that matches the origin or ID (does not have a `type:` prefix)
    const originMatch = buildNode(_functions.KQL_FUNCTION_IS, `${type}.originId`, esKuery.escapeKuery(origin || id));

    // If we are updating an object's spaces (as opposed to copying)...
    if (purpose === 'updateObjectsSpaces') {
      // we never want to match on the raw document `_id` fields.
      // If they are equal, this just means that the object already exists in that space and it's ok.
      const notIdMatch = buildNode(_functions.KQL_FUNCTION_NOT, buildNode(_functions.KQL_FUNCTION_IS, `${type}.id`, esKuery.escapeKuery(`${type}:${id}`)));

      // If this object has an origin ID, then we do still want to match if another object's ID matches the
      // object's origin (idMatchesOrigin), or if another object's origin matches the object's origin (originMatch).
      // But if this object does not have an origin ID, we can skip the idMatchesOrigin part altogether
      // and just check if another object's origin ID matches this object's ID (originMatch).
      // (maybe slightly more efficient?)
      acc.push(buildNode(_functions.KQL_FUNCTION_AND, [notIdMatch, origin ? buildNode(_functions.KQL_FUNCTION_OR, [idMatchesOrigin, originMatch]) : originMatch]));
    } else acc.push([idMatchesOrigin, originMatch]); // If we are copying, things are much simpler

    return acc;
  }, []).flat();
  return buildNode(_functions.KQL_FUNCTION_OR, kueryNodes);
}