"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTooltip = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Custom hook to manage tooltip visibility
 *
 * TODO: both of the `EuiToolTip` usages use `disableScreenReaderOutput`
 * Likely for such usages, the tooltip should fade out on mouse out
 * and not be persisted. The a11y argument no longer applies.
 */
const useTooltip = () => {
  const tooltipRef = (0, _react.useRef)(null);
  const handleMouseOut = () => {
    var _tooltipRef$current;
    (_tooltipRef$current = tooltipRef.current) === null || _tooltipRef$current === void 0 ? void 0 : _tooltipRef$current.hideToolTip();
  };
  return {
    tooltipRef,
    handleMouseOut
  };
};
exports.useTooltip = useTooltip;