"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildBreadcrumbs = buildBreadcrumbs;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/browser-internal/src/project_navigation/breadcrumbs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function prependRootCrumb(rootCrumb, rest) {
  if (rootCrumb) {
    return [rootCrumb, ...rest];
  }
  return rest;
}
function buildBreadcrumbs({
  projectName,
  cloudLinks,
  projectBreadcrumbs,
  activeNodes,
  chromeBreadcrumbs,
  isServerless
}) {
  var _activeNodes$;
  const rootCrumb = buildRootCrumb({
    projectName,
    cloudLinks,
    isServerless
  });
  if (projectBreadcrumbs.params.absolute) {
    return prependRootCrumb(rootCrumb, projectBreadcrumbs.breadcrumbs);
  }

  // breadcrumbs take the first active path
  const activePath = (_activeNodes$ = activeNodes[0]) !== null && _activeNodes$ !== void 0 ? _activeNodes$ : [];
  const navBreadcrumbPath = activePath.filter(n => Boolean(n.title) && n.breadcrumbStatus !== 'hidden');
  const navBreadcrumbs = navBreadcrumbPath.map(node => {
    var _node$deepLink$url, _node$deepLink, _node$deepLink2;
    return {
      href: (_node$deepLink$url = (_node$deepLink = node.deepLink) === null || _node$deepLink === void 0 ? void 0 : _node$deepLink.url) !== null && _node$deepLink$url !== void 0 ? _node$deepLink$url : node.href,
      deepLinkId: (_node$deepLink2 = node.deepLink) === null || _node$deepLink2 === void 0 ? void 0 : _node$deepLink2.id,
      text: node.title
    };
  });

  // if there are project breadcrumbs set, use them
  if (projectBreadcrumbs.breadcrumbs.length !== 0) {
    return prependRootCrumb(rootCrumb, [...navBreadcrumbs, ...projectBreadcrumbs.breadcrumbs]);
  }

  // otherwise try to merge legacy breadcrumbs with navigational project breadcrumbs using deeplinkid
  let chromeBreadcrumbStartIndex = -1;
  let navBreadcrumbEndIndex = -1;
  navBreadcrumbsLoop: for (let i = navBreadcrumbs.length - 1; i >= 0; i--) {
    if (!navBreadcrumbs[i].deepLinkId) continue;
    for (let j = 0; j < chromeBreadcrumbs.length; j++) {
      if (chromeBreadcrumbs[j].deepLinkId === navBreadcrumbs[i].deepLinkId) {
        chromeBreadcrumbStartIndex = j;
        navBreadcrumbEndIndex = i;
        break navBreadcrumbsLoop;
      }
    }
  }
  if (chromeBreadcrumbStartIndex === -1) {
    return prependRootCrumb(rootCrumb, navBreadcrumbs);
  } else {
    return prependRootCrumb(rootCrumb, [...navBreadcrumbs.slice(0, navBreadcrumbEndIndex), ...chromeBreadcrumbs.slice(chromeBreadcrumbStartIndex)]);
  }
}
function buildRootCrumb({
  projectName,
  cloudLinks,
  isServerless
}) {
  if (isServerless) {
    var _cloudLinks$deploymen, _cloudLinks$projects;
    return {
      text: projectName !== null && projectName !== void 0 ? projectName : _i18n.i18n.translate('core.ui.primaryNav.cloud.projectLabel', {
        defaultMessage: 'Project'
      }),
      // increase the max-width of the root breadcrumb to not truncate too soon
      style: {
        maxWidth: '320px'
      },
      popoverContent: /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
        size: "s",
        items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
          key: "project",
          href: (_cloudLinks$deploymen = cloudLinks.deployment) === null || _cloudLinks$deploymen === void 0 ? void 0 : _cloudLinks$deploymen.href,
          icon: 'gear',
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 121,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "core.ui.primaryNav.cloud.linkToProject",
          defaultMessage: "Manage project",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 122,
            columnNumber: 15
          }
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
          key: "projects",
          href: (_cloudLinks$projects = cloudLinks.projects) === null || _cloudLinks$projects === void 0 ? void 0 : _cloudLinks$projects.href,
          icon: 'grid',
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 127,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "core.ui.primaryNav.cloud.linkToAllProjects",
          defaultMessage: "View all projects",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 128,
            columnNumber: 15
          }
        }))],
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 118,
          columnNumber: 9
        }
      }),
      popoverProps: {
        panelPaddingSize: 'none'
      }
    };
  }
  if (cloudLinks.deployment || cloudLinks.deployments) {
    return {
      text: _i18n.i18n.translate('core.ui.primaryNav.cloud.deploymentLabel', {
        defaultMessage: 'Deployment'
      }),
      'data-test-subj': 'deploymentCrumb',
      popoverContent: () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, cloudLinks.deployment && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        href: cloudLinks.deployment.href,
        color: "text",
        iconType: "gear",
        "data-test-subj": "manageDeploymentBtn",
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 149,
          columnNumber: 13
        }
      }, _i18n.i18n.translate('core.ui.primaryNav.cloud.breadCrumbDropdown.manageDeploymentLabel', {
        defaultMessage: 'Manage this deployment'
      })), cloudLinks.deployments && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        href: cloudLinks.deployments.href,
        color: "text",
        iconType: "spaces",
        "data-test-subj": "viewDeploymentsBtn",
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 163,
          columnNumber: 13
        }
      }, cloudLinks.deployments.title)),
      popoverProps: {
        panelPaddingSize: 's',
        zIndex: 6000,
        panelStyle: {
          maxWidth: 240
        },
        panelProps: {
          'data-test-subj': 'deploymentLinksPanel'
        }
      }
    };
  }
}