"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeSliderPopoverContent = TimeSliderPopoverContent;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _time_slider_strings = require("./time_slider_strings");
var _time_slider_anchored_range = require("./time_slider_anchored_range");
var _time_slider_sliding_window_range = require("./time_slider_sliding_window_range");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/controls/public/controls/timeslider_control/components/time_slider_popover_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function TimeSliderPopoverContent({
  isAnchored,
  setIsAnchored,
  value,
  onChange,
  stepSize,
  ticks,
  timeRangeMin,
  timeRangeMax,
  compressed
}) {
  const [displayedValue, setDisplayedValue] = (0, _react.useState)(value);
  const debouncedOnChange = (0, _react.useMemo)(() => (0, _lodash.debounce)(updateTimeslice => {
    onChange(updateTimeslice);
  }, 750), [onChange]);

  /**
   * The following `useEffect` ensures that the changes to the value that come from the embeddable (for example,
   * from the `clear` button on the dashboard) are reflected in the displayed value
   */
  (0, _react.useEffect)(() => {
    setDisplayedValue(value);
  }, [value]);
  const rangeInput = isAnchored ? /*#__PURE__*/_react.default.createElement(_time_slider_anchored_range.TimeSliderAnchoredRange, {
    value: [displayedValue[0] || timeRangeMin, displayedValue[1] || timeRangeMax],
    onChange: newValue => {
      setDisplayedValue(newValue);
      debouncedOnChange(newValue);
    },
    stepSize: stepSize,
    ticks: ticks,
    timeRangeMin: timeRangeMin,
    timeRangeMax: timeRangeMax,
    compressed: compressed,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_time_slider_sliding_window_range.TimeSliderSlidingWindowRange, {
    value: [displayedValue[0] || timeRangeMin, displayedValue[1] || timeRangeMax],
    onChange: newValue => {
      setDisplayedValue(newValue);
      debouncedOnChange(newValue);
    },
    stepSize: stepSize,
    ticks: ticks,
    timeRangeMin: timeRangeMin,
    timeRangeMax: timeRangeMax,
    compressed: compressed,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  });
  const anchorStartToggleButtonLabel = isAnchored ? _time_slider_strings.TimeSliderStrings.control.getUnpinStart() : _time_slider_strings.TimeSliderStrings.control.getPinStart();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "rangeSlider__actions",
    gutterSize: "none",
    "data-test-subj": "timeSlider-popoverContents",
    responsive: false,
    onMouseUp: () => {
      // when the pin is dropped (on mouse up), cancel any pending debounced changes and force the change
      // in value to happen instantly (which, in turn, will re-calculate the from/to for the slider due to
      // the `useEffect` above.
      debouncedOnChange.cancel();
      onChange(displayedValue);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: anchorStartToggleButtonLabel,
    position: "left",
    disableScreenReaderOutput: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: isAnchored ? 'pinFilled' : 'pin',
    onClick: () => {
      const nextIsAnchored = !isAnchored;
      if (nextIsAnchored) {
        onChange([timeRangeMin, value[1]]);
      }
      setIsAnchored(nextIsAnchored);
    },
    "aria-label": anchorStartToggleButtonLabel,
    "data-test-subj": "timeSlider__anchorStartToggleButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 7
    }
  }, rangeInput));
}