"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRemediationList = exports.convertObjectToArray = exports.columns = exports.OverviewTab = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _use_data_view = require("@kbn/cloud-security-posture/src/hooks/use_data_view");
var _helpers = require("@kbn/cloud-security-posture/src/utils/helpers");
var _public = require("@kbn/kibana-react-plugin/public");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _css = require("@emotion/css");
var _copy_button = require("../../../components/copy_button");
var _findings_flyout = require("./findings_flyout");
var _findings_detection_rule_counter = require("./findings_detection_rule_counter");
var _header = require("./findings_right/header");
var _constants = require("../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/pages/configurations/findings_flyout/overview_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const renderValue = item => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "xs",
  direction: "row",
  justifyContent: "flexStart",
  alignItems: "center",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 56,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 57,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  css: {
    whiteSpace: 'nowrap',
    overflow: 'hidden',
    textOverflow: 'ellipsis'
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 58,
    columnNumber: 7
  }
}, item)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 69,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
  textToCopy: item,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 70,
    columnNumber: 7
  }
}, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  "aria-label": _copy_button.COPY_ARIA_LABEL,
  className: (0, _css.css)`
              &:hover {
                cursor: pointer;
              }
            `,
  onClick: copy,
  type: "copy",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 72,
    columnNumber: 11
  }
}))));
const renderTableField = value => {
  if (!value) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 12
      }
    }, _findings_flyout.EMPTY_VALUE);
  }
  if (Array.isArray(value)) {
    return /*#__PURE__*/_react.default.createElement(_cloudSecurityPosture.MultiValueCellPopover, (0, _extends2.default)({
      items: value,
      field: "",
      object: {},
      renderItem: renderValue
    }, value.length === 1 ? {
      firstItemRenderer: item => /*#__PURE__*/_react.default.createElement(_header.TruncatedCopyableText, {
        textToCopy: item,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 101,
          columnNumber: 44
        }
      })
    } : {}, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 7
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_header.TruncatedCopyableText, {
    textToCopy: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }));
};
const columns = exports.columns = [{
  field: 'field',
  name: 'Field',
  'data-test-subj': 'firstNameCell'
}, {
  field: 'value',
  name: 'Value',
  truncateText: true,
  render: value => renderTableField(value)
}];
const convertObjectToArray = obj => {
  if (obj === undefined) return null;
  return Object.keys(obj).filter(key => key !== 'raw').map(key => ({
    field: key,
    value: obj[key]
  }));
};
exports.convertObjectToArray = convertObjectToArray;
const getResourceList = data => [{
  title: '',
  description: data ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    tableCaption: "Demo of EuiBasicTable",
    items: convertObjectToArray(data.resource) || [],
    rowHeader: "Field",
    columns: columns,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 11
    }
  }))) : _findings_flyout.EMPTY_VALUE
}];
const getDetailsList = (data, ruleFlyoutLink, discoverDataViewLink, euiTheme) => {
  var _data$rule, _data$rule2;
  return [{
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "m",
      css: {
        marginBottom: euiTheme === null || euiTheme === void 0 ? void 0 : euiTheme.size.xs
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h1", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.ruleDescription', {
      defaultMessage: 'Rule Description'
    })))), ruleFlyoutLink && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("h1", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      css: {
        textAlign: 'right',
        display: 'flex',
        gap: euiTheme === null || euiTheme === void 0 ? void 0 : euiTheme.size.s,
        alignItems: 'center',
        justifyContent: 'flex-end',
        marginBottom: euiTheme === null || euiTheme === void 0 ? void 0 : euiTheme.size.xs
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "expand",
      color: "primary",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 19
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: ruleFlyoutLink,
      target: "_blank",
      external: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.showRuleDetails', {
      defaultMessage: 'Show rule details'
    }))))))),
    description: (_data$rule = data.rule) !== null && _data$rule !== void 0 && _data$rule.description ? /*#__PURE__*/_react.default.createElement(_findings_flyout.CspFlyoutMarkdown, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 207,
        columnNumber: 7
      }
    }, (_data$rule2 = data.rule) === null || _data$rule2 === void 0 ? void 0 : _data$rule2.description) : _findings_flyout.EMPTY_VALUE
  }, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      css: {
        marginBottom: euiTheme === null || euiTheme === void 0 ? void 0 : euiTheme.size.xs
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("h1", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 215,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.alertsTitle', {
      defaultMessage: 'Alerts'
    }))),
    description: /*#__PURE__*/_react.default.createElement(_findings_detection_rule_counter.FindingsDetectionRuleCounter, {
      finding: data,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 18
      }
    })
  }, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      css: {
        marginBottom: euiTheme === null || euiTheme === void 0 ? void 0 : euiTheme.size.xs
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 226,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("h1", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 227,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.dataViewTitle', {
      defaultMessage: 'Data View'
    }))),
    description: discoverDataViewLink ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: discoverDataViewLink,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 235,
        columnNumber: 7
      }
    }, _cloudSecurityPostureCommon.CDR_MISCONFIGURATIONS_INDEX_PATTERN) : _cloudSecurityPostureCommon.CDR_MISCONFIGURATIONS_INDEX_PATTERN
  }];
};
const getRemediationList = rule => [{
  title: '',
  description: rule !== null && rule !== void 0 && rule.remediation ? /*#__PURE__*/_react.default.createElement(_findings_flyout.CspFlyoutMarkdown, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 7
    }
  }, rule === null || rule === void 0 ? void 0 : rule.remediation) : _findings_flyout.EMPTY_VALUE
}, {
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.rationaleTitle', {
    defaultMessage: 'Rationale'
  }),
  description: rule !== null && rule !== void 0 && rule.rationale ? /*#__PURE__*/_react.default.createElement(_findings_flyout.CspFlyoutMarkdown, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 7
    }
  }, rule.rationale) : _findings_flyout.EMPTY_VALUE
}];
exports.getRemediationList = getRemediationList;
const getEvidenceList = evidence => [{
  title: '',
  description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.findings.findingsFlyout.overviewTab.evidenceDescription",
    defaultMessage: "The specific resource metadata that was evaluated to generate this posture finding",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_findings_flyout.CodeBlock, {
    language: "json",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 11
    }
  }, JSON.stringify(evidence, null, 2)))
}].filter(_helpers.truthy);
const OverviewTab = ({
  data,
  ruleFlyoutLink
}) => {
  var _data$data_stream2, _cdrMisconfigurations2;
  const {
    discover
  } = (0, _public.useKibana)().services;
  const cdrMisconfigurationsDataView = (0, _use_data_view.useDataView)(_cloudSecurityPostureCommon.CDR_MISCONFIGURATIONS_DATA_VIEW_ID_PREFIX);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();

  // link will navigate to our dataview in discover, filtered by the data source of the finding
  const discoverDataViewLink = (0, _react.useMemo)(() => {
    var _discover$locator, _cdrMisconfigurations, _data$data_stream;
    return (_discover$locator = discover.locator) === null || _discover$locator === void 0 ? void 0 : _discover$locator.getRedirectUrl({
      dataViewId: (_cdrMisconfigurations = cdrMisconfigurationsDataView.data) === null || _cdrMisconfigurations === void 0 ? void 0 : _cdrMisconfigurations.id,
      ...(((_data$data_stream = data.data_stream) === null || _data$data_stream === void 0 ? void 0 : _data$data_stream.dataset) && {
        filters: [{
          meta: {
            type: 'phrase',
            key: 'data_stream.dataset'
          },
          query: {
            match_phrase: {
              'data_stream.dataset': data.data_stream.dataset
            }
          }
        }]
      })
    });
  }, [(_data$data_stream2 = data.data_stream) === null || _data$data_stream2 === void 0 ? void 0 : _data$data_stream2.dataset, discover.locator, (_cdrMisconfigurations2 = cdrMisconfigurationsDataView.data) === null || _cdrMisconfigurations2 === void 0 ? void 0 : _cdrMisconfigurations2.id]);
  const evidence = getEvaluationEvidence(data);
  const accordions = (0, _react.useMemo)(() => [{
    initialIsOpen: true,
    title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.aboutTitle', {
      defaultMessage: 'About'
    }),
    id: 'detailsAccordion',
    listItems: getDetailsList(data, ruleFlyoutLink, discoverDataViewLink, euiTheme)
  }, {
    initialIsOpen: true,
    title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.detailsTitle', {
      defaultMessage: 'Resource'
    }),
    id: 'detailsAccordion',
    listItems: getResourceList(data)
  }, {
    initialIsOpen: true,
    title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.remediationTitle', {
      defaultMessage: 'Remediation'
    }),
    id: 'remediationAccordion',
    listItems: getRemediationList(data.rule)
  }, _cloudSecurityPostureCommon.INTERNAL_FEATURE_FLAGS.showFindingFlyoutEvidence && !(0, _lodash.isEmpty)(evidence) && {
    initialIsOpen: true,
    title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.evidenceSourcesTitle', {
      defaultMessage: 'Evidence'
    }),
    id: 'evidenceAccordion',
    listItems: getEvidenceList(evidence)
  }].filter(_helpers.truthy), [data, discoverDataViewLink, euiTheme, ruleFlyoutLink, evidence]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, accordions.map(accordion => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: accordion.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 362,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: accordion.id,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 366,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 367,
        columnNumber: 17
      }
    }, accordion.title)),
    arrowDisplay: "left",
    initialIsOpen: accordion.initialIsOpen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 363,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 373,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: accordion.listItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 374,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 376,
      columnNumber: 11
    }
  }))));
};
exports.OverviewTab = OverviewTab;
const getEvaluationEvidence = data => {
  var _data$rule$benchmark, _data$result;
  if (((_data$rule$benchmark = data.rule.benchmark) === null || _data$rule$benchmark === void 0 ? void 0 : _data$rule$benchmark.id) === _constants.CIS_GCP) {
    var _data$resource, _data$resource$raw, _data$resource2;
    // For CIS GCP, the evidence is the resource.raw field, which may contain a nested 'resource' field
    return ((_data$resource = data.resource) === null || _data$resource === void 0 ? void 0 : (_data$resource$raw = _data$resource.raw) === null || _data$resource$raw === void 0 ? void 0 : _data$resource$raw.resource) || ((_data$resource2 = data.resource) === null || _data$resource2 === void 0 ? void 0 : _data$resource2.raw);
  }
  return (_data$result = data.result) === null || _data$result === void 0 ? void 0 : _data$result.evidence;
};