"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkpadFilters = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _filters_group = require("./filters_group.component");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/workpad_filters/workpad_filters.component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = {
  getGroupBySelectLabel: () => _i18n.i18n.translate('xpack.canvas.workpadFilters.groupBySelect', {
    defaultMessage: 'Group by'
  }),
  getGroupByFilterGroupLabel: () => _i18n.i18n.translate('xpack.canvas.workpadFilters.groupByFilterGroup', {
    defaultMessage: 'Filter group'
  }),
  getGroupByFilterTypeLabel: () => _i18n.i18n.translate('xpack.canvas.workpadFilters.groupByFilterType', {
    defaultMessage: 'Filter type'
  }),
  getGroupByColumnLabel: () => _i18n.i18n.translate('xpack.canvas.workpadFilters.groupByColumn', {
    defaultMessage: 'Column'
  }),
  getWithoutGroupLabel: () => _i18n.i18n.translate('xpack.canvas.workpadFilters.filters_group.withoutGroup', {
    defaultMessage: 'Without group'
  }),
  getBlankValueLabel: () => _i18n.i18n.translate('xpack.canvas.workpadFilters.filters_group.blankValue', {
    defaultMessage: '(Blank)'
  })
};
const groupByOptions = [{
  value: 'filterGroup',
  text: strings.getGroupByFilterGroupLabel()
}, {
  value: 'type',
  text: strings.getGroupByFilterTypeLabel()
}, {
  value: 'column',
  text: strings.getGroupByColumnLabel()
}];
const WorkpadFilters = ({
  filtersGroups,
  onGroupByChange,
  groupFiltersByField
}) => {
  var _formatByKey;
  const groupedByFilterGroupField = groupFiltersByField === 'filterGroup';
  const formatter = groupFiltersByField ? (_formatByKey = (0, _utils.formatByKey)(groupFiltersByField)) !== null && _formatByKey !== void 0 ? _formatByKey : _lodash.identity : _lodash.identity;
  const preparedFilterGroups = filtersGroups.map(filterGroup => {
    var _formatter;
    return {
      ...filterGroup,
      name: (_formatter = formatter(filterGroup.name)) !== null && _formatter !== void 0 ? _formatter : groupedByFilterGroupField ? strings.getWithoutGroupLabel() : strings.getBlankValueLabel()
    };
  });
  const filtersGroupsComponents = preparedFilterGroups.map((filtersGroup, index) => {
    return /*#__PURE__*/_react.default.createElement(_filters_group.FiltersGroup, {
      key: `filter-group-${index}`,
      id: index,
      filtersGroup: filtersGroup,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 12
      }
    });
  });
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasSidebar__panel canvasSidebar__expandable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 15
    }
  }, strings.getGroupBySelectLabel()))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    compressed: true,
    options: groupByOptions,
    value: groupFiltersByField,
    onChange: e => onGroupByChange(e.target.value),
    "aria-label": "Use aria labels when no actual label is in use",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  })))), filtersGroupsComponents);
};
exports.WorkpadFilters = WorkpadFilters;