"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextStylePicker = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _font_picker = require("../font_picker");
var _color_picker_popover = require("../color_picker_popover");
var _font_sizes = require("./font_sizes");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/text_style_picker/text_style_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = {
  getAlignCenterOption: () => _i18n.i18n.translate('xpack.canvas.textStylePicker.alignCenterOption', {
    defaultMessage: 'Align center'
  }),
  getAlignLeftOption: () => _i18n.i18n.translate('xpack.canvas.textStylePicker.alignLeftOption', {
    defaultMessage: 'Align left'
  }),
  getAlignRightOption: () => _i18n.i18n.translate('xpack.canvas.textStylePicker.alignRightOption', {
    defaultMessage: 'Align right'
  }),
  getAlignmentOptionsControlLegend: () => _i18n.i18n.translate('xpack.canvas.textStylePicker.alignmentOptionsControl', {
    defaultMessage: 'Alignment options'
  }),
  getFontColorLabel: () => _i18n.i18n.translate('xpack.canvas.textStylePicker.fontColorLabel', {
    defaultMessage: 'Font Color'
  }),
  getFontSizeLabel: () => _i18n.i18n.translate('xpack.canvas.textStylePicker.fontSizeLabel', {
    defaultMessage: 'Size'
  }),
  getStyleBoldOption: () => _i18n.i18n.translate('xpack.canvas.textStylePicker.styleBoldOption', {
    defaultMessage: 'Bold'
  }),
  getStyleItalicOption: () => _i18n.i18n.translate('xpack.canvas.textStylePicker.styleItalicOption', {
    defaultMessage: 'Italic'
  }),
  getStyleUnderlineOption: () => _i18n.i18n.translate('xpack.canvas.textStylePicker.styleUnderlineOption', {
    defaultMessage: 'Underline'
  }),
  getStyleOptionsControlLegend: () => _i18n.i18n.translate('xpack.canvas.textStylePicker.styleOptionsControl', {
    defaultMessage: 'Style options'
  })
};
const alignmentButtons = [{
  id: 'left',
  label: strings.getAlignLeftOption(),
  iconType: 'editorAlignLeft'
}, {
  id: 'center',
  label: strings.getAlignCenterOption(),
  iconType: 'editorAlignCenter'
}, {
  id: 'right',
  label: strings.getAlignRightOption(),
  iconType: 'editorAlignRight'
}];
const styleButtons = [{
  id: 'bold',
  label: strings.getStyleBoldOption(),
  iconType: 'editorBold'
}, {
  id: 'italic',
  label: strings.getStyleItalicOption(),
  iconType: 'editorItalic'
}, {
  id: 'underline',
  label: strings.getStyleUnderlineOption(),
  iconType: 'editorUnderline'
}];
const TextStylePicker = ({
  align = 'left',
  color,
  colors,
  family,
  italic = false,
  onChange,
  size = 14,
  underline = false,
  weight = 'normal'
}) => {
  const [style, setStyle] = (0, _react.useState)({
    align,
    color,
    family,
    italic,
    size,
    underline,
    weight
  });
  const stylesSelectedMap = {
    ['bold']: weight === 'bold',
    ['italic']: Boolean(italic),
    ['underline']: Boolean(underline)
  };
  if (!isNaN(size) && _font_sizes.fontSizes.indexOf(Number(size)) === -1) {
    _font_sizes.fontSizes.push(Number(size));
    _font_sizes.fontSizes.sort((a, b) => a - b);
  }
  const doChange = (propName, value) => {
    const newStyle = {
      ...style,
      [propName]: value
    };
    setStyle(newStyle);
    onChange(newStyle);
  };
  const onStyleChange = optionId => {
    let prop;
    let value;
    if (optionId === 'bold') {
      prop = 'weight';
      value = !stylesSelectedMap[optionId] ? 'bold' : 'normal';
    } else {
      prop = optionId;
      value = !stylesSelectedMap[prop];
    }
    doChange(prop, value);
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasTextStylePicker",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 9
    }
  }, family ? /*#__PURE__*/_react.default.createElement(_font_picker.FontPicker, {
    value: family,
    onSelect: value => doChange('family', value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_font_picker.FontPicker, {
    onSelect: value => doChange('family', value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    compressed: true,
    value: size,
    onChange: e => doChange('size', Number(e.target.value)),
    options: _font_sizes.fontSizes.map(fontSize => ({
      text: String(fontSize),
      value: fontSize
    })),
    prepend: strings.getFontSizeLabel(),
    "aria-label": strings.getFontSizeLabel(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      fontSize: 0
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_color_picker_popover.ColorPickerPopover, {
    value: color,
    onChange: value => doChange('color', value),
    colors: colors,
    ariaLabel: strings.getFontColorLabel(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    options: styleButtons,
    buttonSize: "compressed",
    idToSelectedMap: stylesSelectedMap,
    onChange: onStyleChange,
    type: "multi",
    isIconOnly: true,
    className: "canvasSidebar__buttonGroup",
    legend: strings.getStyleOptionsControlLegend(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    options: alignmentButtons,
    buttonSize: "compressed",
    isIconOnly: true,
    idSelected: align,
    onChange: optionId => doChange('align', optionId),
    className: "canvasSidebar__buttonGroup",
    legend: strings.getAlignmentOptionsControlLegend(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 11
    }
  }))));
};
exports.TextStylePicker = TextStylePicker;
TextStylePicker.propTypes = {
  family: _propTypes.default.string,
  size: _propTypes.default.number,
  align: _propTypes.default.oneOf(['left', 'center', 'right']),
  color: _propTypes.default.string,
  weight: _propTypes.default.oneOf(['normal', 'bold']),
  underline: _propTypes.default.bool,
  italic: _propTypes.default.bool,
  onChange: _propTypes.default.func.isRequired,
  colors: _propTypes.default.array
};
TextStylePicker.defaultProps = {
  align: 'left',
  size: 14,
  weight: 'normal'
};