"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkpadTemplates = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _tags_registry = require("../../../lib/tags_registry");
var _tag_list = require("../../tag_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/home/workpad_templates/workpad_templates.component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const WorkpadTemplates = ({
  templates,
  onCreateWorkpad
}) => {
  const columns = [{
    field: 'name',
    name: strings.getTableNameColumnTitle(),
    sortable: true,
    width: '30%',
    dataType: 'string',
    render: (name, template) => {
      const templateName = name.length ? name : 'Unnamed Template';
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        onClick: () => onCreateWorkpad(template),
        "aria-label": strings.getCloneTemplateLinkAriaLabel(templateName),
        type: "button",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 35,
          columnNumber: 11
        }
      }, templateName);
    }
  }, {
    field: 'help',
    name: strings.getTableDescriptionColumnTitle(),
    sortable: false,
    dataType: 'string',
    width: '30%'
  }, {
    field: 'tags',
    name: strings.getTableTagsColumnTitle(),
    sortable: false,
    dataType: 'string',
    width: '30%',
    render: tags => /*#__PURE__*/_react.default.createElement(_tag_list.TagList, {
      tags: tags,
      tagType: "health",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 35
      }
    })
  }];
  let uniqueTagNames = [];
  templates.forEach(template => {
    const {
      tags
    } = template;
    tags.forEach(tag => uniqueTagNames.push(tag));
    uniqueTagNames = (0, _lodash.uniq)(uniqueTagNames);
  });
  const uniqueTags = uniqueTagNames.map(name => _tags_registry.tagsRegistry.get(name) || {
    color: undefined,
    name
  });
  const filters = [{
    type: 'field_value_selection',
    field: 'tags',
    name: 'Tags',
    multiSelect: true,
    options: uniqueTags.map(tag => ({
      value: tag.name,
      name: tag.name,
      view: /*#__PURE__*/_react.default.createElement(_tag_list.TagList, {
        tags: [tag.name],
        tagType: "health",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 87,
          columnNumber: 15
        }
      })
    }))
  }];
  const search = {
    box: {
      incremental: true,
      schema: true
    },
    filters
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    itemId: "id",
    items: templates,
    columns: columns,
    search: search,
    sorting: {
      sort: {
        field: 'name',
        direction: 'asc'
      }
    },
    pagination: true,
    "data-test-subj": "canvasTemplatesTable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  });
};
exports.WorkpadTemplates = WorkpadTemplates;
const strings = {
  getCloneTemplateLinkAriaLabel: templateName => _i18n.i18n.translate('xpack.canvas.workpadTemplates.cloneTemplateLinkAriaLabel', {
    defaultMessage: `Clone workpad template ''{templateName}''`,
    values: {
      templateName
    }
  }),
  getTableDescriptionColumnTitle: () => _i18n.i18n.translate('xpack.canvas.workpadTemplates.table.descriptionColumnTitle', {
    defaultMessage: 'Description'
  }),
  getTableNameColumnTitle: () => _i18n.i18n.translate('xpack.canvas.workpadTemplates.table.nameColumnTitle', {
    defaultMessage: 'Template name'
  }),
  getTableTagsColumnTitle: () => _i18n.i18n.translate('xpack.canvas.workpadTemplates.table.tagsColumnTitle', {
    defaultMessage: 'Tags',
    description: 'This column contains relevant tags that indicate what type of template ' + 'is displayed. For example: "report", "presentation", etc.'
  }),
  getTemplateSearchPlaceholder: () => _i18n.i18n.translate('xpack.canvas.workpadTemplates.searchPlaceholder', {
    defaultMessage: 'Find template'
  }),
  getCreatingTemplateLabel: templateName => _i18n.i18n.translate('xpack.canvas.workpadTemplates.creatingTemplateLabel', {
    defaultMessage: `Creating from template ''{templateName}''`,
    values: {
      templateName
    }
  })
};