"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mobileRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _ioTsUtils = require("@kbn/io-ts-utils");
var _get_apm_event_client = require("../../lib/helpers/get_apm_event_client");
var _create_apm_server_route = require("../apm_routes/create_apm_server_route");
var _default_api_types = require("../default_api_types");
var _comparison_rt = require("../../../common/comparison_rt");
var _get_mobile_http_requests = require("./get_mobile_http_requests");
var _get_mobile_filters = require("./get_mobile_filters");
var _get_mobile_sessions = require("./get_mobile_sessions");
var _get_mobile_stats = require("./get_mobile_stats");
var _get_mobile_location_stats = require("./get_mobile_location_stats");
var _get_mobile_terms_by_field = require("./get_mobile_terms_by_field");
var _get_mobile_main_statistics_by_field = require("./get_mobile_main_statistics_by_field");
var _get_mobile_detailed_statistics_by_field = require("./get_mobile_detailed_statistics_by_field");
var _get_mobile_most_used_charts = require("./get_mobile_most_used_charts");
var _route = require("./errors/route");
var _route2 = require("./crashes/route");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mobileFiltersRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/mobile/filters',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.kueryRt, _default_api_types.rangeRt, _default_api_types.environmentRt, t.partial({
      transactionType: t.string
    })])
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      kuery,
      environment,
      start,
      end,
      transactionType
    } = params.query;
    const filters = await (0, _get_mobile_filters.getMobileFilters)({
      kuery,
      environment,
      transactionType,
      start,
      end,
      serviceName,
      apmEventClient
    });
    return {
      mobileFilters: filters
    };
  }
});
const mobileChartsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/mobile-services/{serviceName}/most_used_charts',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.kueryRt, _default_api_types.rangeRt, _default_api_types.environmentRt, t.partial({
      transactionType: t.string
    })])
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      kuery,
      environment,
      start,
      end,
      transactionType
    } = params.query;
    const mostUsedCharts = await (0, _get_mobile_most_used_charts.getMobileMostUsedCharts)({
      kuery,
      environment,
      transactionType,
      start,
      end,
      serviceName,
      apmEventClient
    });
    return {
      mostUsedCharts
    };
  }
});
const mobileStatsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/mobile-services/{serviceName}/stats',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.kueryRt, _default_api_types.rangeRt, _default_api_types.environmentRt, _comparison_rt.offsetRt, t.partial({
      transactionType: t.string
    })])
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      kuery,
      environment,
      start,
      end,
      offset
    } = params.query;
    const stats = await (0, _get_mobile_stats.getMobileStatsPeriods)({
      kuery,
      environment,
      start,
      end,
      serviceName,
      apmEventClient,
      offset
    });
    return stats;
  }
});
const mobileLocationStatsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/mobile-services/{serviceName}/location/stats',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.kueryRt, _default_api_types.rangeRt, _default_api_types.environmentRt, _comparison_rt.offsetRt, t.partial({
      locationField: t.string
    })])
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      kuery,
      environment,
      start,
      end,
      locationField,
      offset
    } = params.query;
    const locationStats = await (0, _get_mobile_location_stats.getMobileLocationStatsPeriods)({
      kuery,
      environment,
      start,
      end,
      serviceName,
      apmEventClient,
      locationField,
      offset
    });
    return locationStats;
  }
});
const sessionsChartRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/mobile-services/{serviceName}/transactions/charts/sessions',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.kueryRt, _default_api_types.rangeRt, _default_api_types.environmentRt, _comparison_rt.offsetRt, t.partial({
      transactionType: t.string,
      transactionName: t.string
    })])
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      kuery,
      environment,
      start,
      end,
      transactionName,
      offset
    } = params.query;
    const {
      currentPeriod,
      previousPeriod
    } = await (0, _get_mobile_sessions.getMobileSessions)({
      kuery,
      environment,
      transactionName,
      start,
      end,
      serviceName,
      apmEventClient,
      offset
    });
    return {
      currentPeriod,
      previousPeriod
    };
  }
});
const httpRequestsChartRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/mobile-services/{serviceName}/transactions/charts/http_requests',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.kueryRt, _default_api_types.rangeRt, _default_api_types.environmentRt, _comparison_rt.offsetRt, t.partial({
      transactionType: t.string,
      transactionName: t.string
    })])
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      kuery,
      environment,
      start,
      end,
      transactionName,
      offset
    } = params.query;
    const {
      currentPeriod,
      previousPeriod
    } = await (0, _get_mobile_http_requests.getMobileHttpRequests)({
      kuery,
      environment,
      transactionName,
      start,
      end,
      serviceName,
      apmEventClient,
      offset
    });
    return {
      currentPeriod,
      previousPeriod
    };
  }
});
const mobileTermsByFieldRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/mobile-services/{serviceName}/terms',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.kueryRt, _default_api_types.rangeRt, _default_api_types.environmentRt, t.type({
      size: _ioTsUtils.toNumberRt,
      fieldName: t.string
    })])
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      kuery,
      environment,
      start,
      end,
      size,
      fieldName
    } = params.query;
    const terms = await (0, _get_mobile_terms_by_field.getMobileTermsByField)({
      kuery,
      environment,
      start,
      end,
      serviceName,
      apmEventClient,
      fieldName,
      size
    });
    return {
      terms
    };
  }
});
const mobileMainStatisticsByField = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/mobile-services/{serviceName}/main_statistics',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.kueryRt, _default_api_types.rangeRt, _default_api_types.environmentRt, t.type({
      field: t.string
    })])
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      kuery,
      environment,
      start,
      end,
      field
    } = params.query;
    return await (0, _get_mobile_main_statistics_by_field.getMobileMainStatisticsByField)({
      kuery,
      environment,
      start,
      end,
      serviceName,
      apmEventClient,
      field
    });
  }
});
const mobileDetailedStatisticsByField = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/mobile-services/{serviceName}/detailed_statistics',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.kueryRt, _default_api_types.rangeRt, _comparison_rt.offsetRt, _default_api_types.environmentRt, t.type({
      field: t.string,
      fieldValues: _ioTsUtils.jsonRt.pipe(t.array(t.string))
    })])
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      kuery,
      environment,
      start,
      end,
      field,
      offset,
      fieldValues
    } = params.query;
    return await (0, _get_mobile_detailed_statistics_by_field.getMobileDetailedStatisticsByFieldPeriods)({
      kuery,
      environment,
      start,
      end,
      serviceName,
      apmEventClient,
      field,
      fieldValues,
      offset
    });
  }
});
const mobileRouteRepository = exports.mobileRouteRepository = {
  ..._route.mobileErrorRoutes,
  ..._route2.mobileCrashRoutes,
  ...mobileFiltersRoute,
  ...mobileChartsRoute,
  ...sessionsChartRoute,
  ...httpRequestsChartRoute,
  ...mobileStatsRoute,
  ...mobileLocationStatsRoute,
  ...mobileTermsByFieldRoute,
  ...mobileMainStatisticsByField,
  ...mobileDetailedStatisticsByField
};