"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicySelector = PolicySelector;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/tutorial/config_agent/policy_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function PolicySelector({
  options,
  selectedOption,
  onChange,
  fleetLink
}) {
  const {
    fleetAgents,
    standalone
  } = (0, _lodash.groupBy)(options, 'type');
  const standaloneComboboxOptions = (standalone === null || standalone === void 0 ? void 0 : standalone.map(({
    key,
    label
  }) => ({
    key,
    label
  }))) || [];
  const fleetAgentsComboboxOptions = fleetAgents !== null && fleetAgents !== void 0 && fleetAgents.length ? [{
    key: 'fleet_policies',
    label: _i18n.i18n.translate('xpack.apm.tutorial.agent_config.fleetPoliciesLabel', {
      defaultMessage: 'Fleet policies'
    }),
    options: fleetAgents.map(({
      key,
      label
    }) => ({
      key,
      label
    }))
  }] : [];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.apm.tutorial.agent_config.choosePolicyLabel', {
      defaultMessage: 'Choose policy'
    }),
    labelAppend: fleetLink && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "apmPolicySelectorLink",
      href: fleetLink.href,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 13
      }
    }, fleetLink.label)),
    helpText: _i18n.i18n.translate('xpack.apm.tutorial.agent_config.choosePolicy.helper', {
      defaultMessage: 'Adds the selected policy configuration to the snippet below.'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": `policySelector_${selectedOption === null || selectedOption === void 0 ? void 0 : selectedOption.key}`,
    isClearable: false,
    singleSelection: {
      asPlainText: true
    },
    options: [...standaloneComboboxOptions, ...fleetAgentsComboboxOptions],
    selectedOptions: selectedOption ? [{
      key: selectedOption.key,
      label: selectedOption.label
    }] : [],
    onChange: selectedOptions => {
      const newSelectedOption = options.find(({
        key
      }) => key === selectedOptions[0].key);
      onChange(newSelectedOption);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }));
}